/**********************************************************************
MPEG-4 Audio VM

This software module was originally developed by
  Y.B. Thomas Kim and S.H. Park (Samsung AIT)
and edited by
  Y.B. Thomas Kim (Samsung AIT) on 1997-11-06

in the course of development of the MPEG-2 NBC/MPEG-4 Audio standard
ISO/IEC 13818-7, 14496-1,2 and 3. This software module is an
implementation of a part of one or more MPEG-2 NBC/MPEG-4 Audio tools
as specified by the MPEG-2 NBC/MPEG-4 Audio standard. ISO/IEC gives
users of the MPEG-2 NBC/MPEG-4 Audio standards free license to this
software module or modifications thereof for use in hardware or
software products claiming conformance to the MPEG-2 NBC/ MPEG-4 Audio
standards. Those intending to use this software module in hardware or
software products are advised that this use may infringe existing
patents. The original developer of this software module and his/her
company, the subsequent editors and their companies, and ISO/IEC have
no liability for use of this software module or modifications thereof
in an implementation. Copyright is not released for non MPEG-2
NBC/MPEG-4 Audio conforming products. The original developer retains
full right to use the code for his/her own purpose, assign or donate
the code to a third party and to inhibit third party from using the
code for non MPEG-2 NBC/MPEG-4 Audio conforming products. This
copyright notice must be included in all copies or derivative works.

Copyright (c) 1997.

**********************************************************************/
/* ARITHMETIC ENCODING ALGORITHM. */
#include <stdio.h>
#include <math.h>
#include "sam_encode.h"
#include "sam_facoding.h"

static void bit_plus_follow(int, int *);

/* CURRENT STATE OF THE ENCODING */

static code_value low, high; 	/* Ends of the current code region.	*/
static long bits_to_follow;		/* Number of opposite bits to output 	*/
				/* after the next bit.			*/

static long total_codelen;  	/* total arithmetic code length */
static int	used_bits;
static int	target_bits;
static int	overflow;
static int	acode_btstr[64];

#ifdef __cplusplus
extern "C" {
#endif

static int put_acode2bs(int, int *, int, int);

#ifdef __cplusplus
}
#endif

/* START ENCODING A STREAM OF SYMBOLS. */

void sam_start_encoding(int ubits, int tbits)
{
	int	i;

	low = 0;		/* full code range. */
	high = Top_value;	
	bits_to_follow = 0;	/* No bits to follow next. */
	total_codelen = 0;

	used_bits = ubits;
	target_bits = tbits;
	overflow = 0;

	for(i = 0; i < 64; i++)
		acode_btstr[i] = 0;
}

/* ENCODE A SYMBOL. */
int
sam_encode_symbol(
	int symbol,		/* Symbol to encode		*/
	int armodel[],	/* Cumulative symbol freqencies */
	double *est_len,	/* code length estimated by the probability */
	int wflag)
{
	long range;		/* Size of the current code region */
	int  pre_codelen;
	int len;
	int	result;
	int	symlen;
	double prob;
	static double	log2val=0;

	if(log2val == 0)
		log2val = log((double)2.0);
	
	range = (long)(high-low) + 1;
	len = 0;

	/* Narrow the code region to that allotted to this symbol. */ 
	if (symbol > 0)
		high  = low + (range * armodel[symbol-1])/16384. - 1;
	low  = low + (range * armodel[symbol])/16384.;
	pre_codelen = total_codelen;

	if (symbol > 0)
	 	prob = (double)(armodel[symbol-1]-armodel[symbol])/16384.;
	else
	 	prob = (double)(16384-armodel[symbol])/16384.;
	if(prob == 0.) {
		fprintf(stderr, "error : encode_symbol : symbol = %d, cum_freq : %d, %d\n", symbol, armodel[symbol], armodel[symbol-1]);
		fflush(stderr);
		prob = 1;
	}

	*est_len += ( -log(prob)/log2val );

	while (1) {
		if (high < Half) {
			bit_plus_follow(0, acode_btstr+len);
			len = (total_codelen-pre_codelen);
		}
		else if (low >= Half ) {
			bit_plus_follow(1, acode_btstr+len);
			len = (total_codelen-pre_codelen);
			low -= Half;
			high -= Half;
		}
		else if (low >= First_qtr &&
			 high <Third_qtr) {
			bits_to_follow++;
			low -= First_qtr;
			high -= First_qtr;
		}
		else 
			break;

		low = 2 * low;		/* Scale up code range. */
		high = 2 * high + 1;
	}

	symlen = total_codelen - pre_codelen;

	if(wflag) {
		result = put_acode2bs(symlen, acode_btstr, used_bits, target_bits);
		if(result < 0) return -1;
	}
	used_bits += symlen;

	return symlen;
}


/* FINISH ENCODING THE STREAM. */

int sam_done_encoding(int wflag)
{
	int symlen=bits_to_follow+2;
	void bits_plus_follow();

	bits_to_follow++;
	if (low<First_qtr) bit_plus_follow(0, acode_btstr);
	else		   bit_plus_follow(1, acode_btstr);

	if(wflag && !overflow) {
		put_acode2bs(symlen, acode_btstr, used_bits, target_bits);
	}
	if(!overflow)
		used_bits += symlen;

	return used_bits;
}


/* OUTPUT BITS PLUS FOLLOWING OPPOSITE BITS */

static void bit_plus_follow(int bit, int *btstr)
{
	int	*pbtstr;

	pbtstr = btstr;
	if (bit) *pbtstr = 1;
	else	 *pbtstr = 0;
	pbtstr++;
	total_codelen++;
	while(bits_to_follow>0) {
		if (bit) *pbtstr = 0; 
		else     *pbtstr = 1;
		pbtstr++;
		total_codelen++;
		bits_to_follow--;
	}
}

static int put_acode2bs(
	int	btstr_len,
	int	*btstr,
	int	cur_frame_pos,
	int	frame_len)
{
	int i, pos;
	unsigned int	data;

	pos = cur_frame_pos;
	data = 0;
	for (i=0; i<btstr_len && pos<frame_len; i++, pos++) {
		data <<= 1;
		if (btstr[i]) data |= 0x01;
	}
	if(pos < frame_len) {
		sam_putbits2bs(data, i);
		return i;
	} else {
		overflow = 1;
		return -1;
	}
}
