/**********************************************************************
MPEG-4 Audio VM

This software module was originally developed by
  Y.B. Thomas Kim and S.H. Park (Samsung AIT)
and edited by
  Y.B. Thomas Kim (Samsung AIT) on 1997-08-25

in the course of development of the MPEG-2 NBC/MPEG-4 Audio standard
ISO/IEC 13818-7, 14496-1,2 and 3. This software module is an
implementation of a part of one or more MPEG-2 NBC/MPEG-4 Audio tools
as specified by the MPEG-2 NBC/MPEG-4 Audio standard. ISO/IEC gives
users of the MPEG-2 NBC/MPEG-4 Audio standards free license to this
software module or modifications thereof for use in hardware or
software products claiming conformance to the MPEG-2 NBC/ MPEG-4 Audio
standards. Those intending to use this software module in hardware or
software products are advised that this use may infringe existing
patents. The original developer of this software module and his/her
company, the subsequent editors and their companies, and ISO/IEC have
no liability for use of this software module or modifications thereof
in an implementation. Copyright is not released for non MPEG-2
NBC/MPEG-4 Audio conforming products. The original developer retains
full right to use the code for his/her own purpose, assign or donate
the code to a third party and to inhibit third party from using the
code for non MPEG-2 NBC/MPEG-4 Audio conforming products. This
copyright notice must be included in all copies or derivative works.

Copyright (c) 1997.

**********************************************************************/

#ifndef _sam_scale_h_
#define _sam_scale_h_

typedef struct {
	int sampling_frequency;
	int	*scale_index_long;
	int *scale_index_short;
	int *scale_qbw_long;
	int *scale_qbw_short;
} SAM_SCALE_INFO;


int scale_findex_l_48k[50]={
  160, 168, 180, 192, 200, 212, 224, 232, 
  244, 256, 264, 276, 288, 296, 308, 320, 
  328, 340, 352, 360, 372, 384, 392, 404, 
  416, 424, 436, 448, 456, 468, 480, 488, 
  500, 512, 520, 532, 544, 552, 564, 576, 
  584, 596, 608, 616, 628, 640, 648, 660, 
  672
};
int scale_findex_l_44k[50]={
  176, 184, 192, 208, 216, 232, 240, 256,
  264, 280, 288, 304, 312, 320, 336, 352,
  360, 368, 384, 392, 408, 416, 424, 440,
  456, 464, 472, 488, 496, 512, 520, 528,
  544, 560, 568, 576, 592, 600, 616, 624,
  632, 648, 664, 672, 680, 696, 704, 720,
  728
};
int scale_findex_l_32k[50]={
   240,  264,  292,  320,  336,  352,  368,  384,
   416,  440,  464,  488,  512,  536,  560,  584,
   608,  624,  640,  656,  672,  696,  720,  744,
   768,  776,  788,  800,  808,  820,  832,  848,
   864,  896,  928,  960,  992, 1024, 1024, 1024,
  1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024,
  1024,
};

int scale_findex_l_24k[50]={
   336,  364,  380,  396,  432,  468,  508,  552,
   600,  648,  696,  732,  768,  800,  832,  864,
   896,  912,  928,  944,  960,  976,  992, 1008,
  1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024,
  1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024,
  1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024,
  1024,
};

int scale_findex_l_22k[50]={
   364,  396,  432,  468,  488,  508,  540,  572,
   600,  632,  664,  696,  728,  768,  808,  848,
   896,  912,  928,  944,  960,  960,  992,  992,
  1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024,
  1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024,
  1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024,
  1024,
};
int scale_findex_l_16k[50]={
   492,  532,  572,  616,  664,  716,  772,  832,
   896,  960,  960,  960, 1024, 1024, 1024, 1024,
  1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024,
  1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024,
  1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024,
  1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024,
  1024,
};
int scale_findex_l_12k[50]={
   664,  716,  772,  832,  896,  960,  960, 1024,
  1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024,
  1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024,
  1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024,
  1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024,
  1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024,
  1024,
};
int scale_findex_l_11k[50]={
   716,  772,  832,  896,  960,  960, 1024, 1024,
  1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024,
  1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024,
  1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024,
  1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024,
  1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024,
  1024,
};
int scale_findex_l_08k[50]={
  944, 944, 944, 944, 944, 944, 944, 944,
  944, 944, 944, 944, 944, 944, 944, 944,
  944, 944, 944, 944, 944, 944, 944, 944,
  944, 944, 944, 944, 944, 944, 944, 944,
  944, 944, 944, 944, 944, 944, 944, 944,
  944, 944, 944, 944, 944, 944, 944, 944,
  944,
};


int scale_findex_s_48k[50]={
  20,  20,  20,  24,  24,  24,  28,  28,
  28,  32,  32,  32,  36,  36,  36,  40, 
  40,  40,  44,  44,  44,  48,  48,  48,
  52,  52,  52,  56,  56,  56,  60,  60,
  60,  64,  64,  64,  68,  68,  68,  72,
  72,  72,  76,  76,  76,  80,  80,  80,
  84
};
int scale_findex_s_44k[50]={
  20,  20,  24,  24,  24,  28,  28,  32,
  32,  36,  36,  36,  40,  40,  40,  44,
  44,  44,  48,  48,  52,  52,  52,  56,
  56,  56,  60,  60,  64,  64,  64,  68,
  68,  68,  72,  72,  76,  76,  76,  80,
  80,  80,  84,  84,  84,  88,  88,  88,
  92
};
int scale_findex_s_32k[50]={
   28,  32,  36,  40,  40,  44,  44,  48,
   52,  52,  56,  60,  64,  64,  68,  72,
   76,  76,  80,  80,  84,  84,  88,  92,
   96,  96,  96, 100, 100, 100, 104, 104,
  108, 112, 116, 120, 124, 128, 128, 128,
  128, 128, 128, 128, 128, 128, 128, 128,
  128,
};
int scale_findex_s_24k[50]={
  36,  44,  44,  48,  52,  56,  60,  68,
  72,  80,  88,  88,  96, 100, 104, 108,
 112, 112, 116, 116, 120, 120, 124, 124,
 128, 128, 128, 128, 128, 128, 128, 128,
 128, 128, 128, 128, 128, 128, 128, 128,
 128, 128, 128, 128, 128, 128, 128, 128,
 128,
};
int scale_findex_s_22k[50]={
  44,  48,  52,  56,  60,  60,  64,  68,
  68,  72,  76,  80,  88,  88,  92,  96,
  96, 100, 104, 108, 112, 120, 120, 120,
 120, 128, 128, 128, 128, 128, 128, 128,
 128, 128, 128, 128, 128, 128, 128, 128,
 128, 128, 128, 128, 128, 128, 128, 128,
 128,
};
int scale_findex_s_16k[50]={
  60,  64,  68,  76,  80,  88,  96, 104,
 112, 120, 120, 120, 128, 128, 128, 128,
 128, 128, 128, 128, 128, 128, 128, 128,
 128, 128, 128, 128, 128, 128, 128, 128,
 128, 128, 128, 128, 128, 128, 128, 128,
 128, 128, 128, 128, 128, 128, 128, 128,
 128,
};
int scale_findex_s_12k[50]={
  80,  88,  96, 104, 112, 120, 120, 128,
 128, 128, 128, 128, 128, 128, 128, 128,
 128, 128, 128, 128, 128, 128, 128, 128,
 128, 128, 128, 128, 128, 128, 128, 128,
 128, 128, 128, 128, 128, 128, 128, 128,
 128, 128, 128, 128, 128, 128, 128, 128,
 128,
};
int scale_findex_s_11k[50]={
  88,  96, 104, 112, 120, 120, 128, 128,
 128, 128, 128, 128, 128, 128, 128, 128,
 128, 128, 128, 128, 128, 128, 128, 128,
 128, 128, 128, 128, 128, 128, 128, 128,
 128, 128, 128, 128, 128, 128, 128, 128,
 128, 128, 128, 128, 128, 128, 128, 128,
 128,
};
int scale_findex_s_08k[50]={
  108, 108, 108, 108, 108, 108, 108, 108,
  108, 108, 108, 108, 108, 108, 108, 108,
  108, 108, 108, 108, 108, 108, 108, 108,
  108, 108, 108, 108, 108, 108, 108, 108,
  108, 108, 108, 108, 108, 108, 108, 108,
  108, 108, 108, 108, 108, 108, 108, 108,
  108,
};


int scale_qbw_48k[50]={
  22,  23,  24,  24,  25,  25,  26,  26,
  27,  27,  27,  28,  28,  29,  29,  29,
  30,  30,  30,  31,  31,  31,  32,  32,
  32,  33,  33,  33,  34,  34,  34,  35,
  35,  35,  36,  36,  36,  37,  37,  37,
  38,  38,  38,  39,  39,  39,  40,  40,
  40
};
int scale_qbw_44k[50]={
  23,  24,  24,  25,  25,  26,  26,  27, 
  27,  28,  28,  29,  29,  29,  30,  30, 
  31,  31,  31,  32,  32,  32,  33,  33, 
  34,  34,  34,  35,  35,  35,  36,  36, 
  36,  37,  37,  37,  38,  38,  39,  39, 
  39,  40,  40,  40,  41,  41,  41,  42, 
  42
};
int scale_qbw_32k[50]={
  26,  27,  28,  29,  30,  30,  31,  31,
  32,  33,  34,  35,  35,  36,  37,  38,
  38,  39,  39,  40,  40,  41,  42,  43,
  43,  44,  44,  44,  45,  45,  45,  46,
  46,  47,  48,  49,  50,  51,  51,  51,
  51,  51,  51,  51,  51,  51,  51,  51,
  51,
};
int scale_qbw_24k[50]={
  33,  34,  35,  35,  36,  37,  38,  39,
  40,  41,  42,  43,  43,  44,  44,  45,
  45,  46,  46,  46,  46,  47,  47,  47,
  47,  47,  47,  47,  47,  47,  47,  47,
  47,  47,  47,  47,  47,  47,  47,  47,
  47,  47,  47,  47,  47,  47,  47,  47,
  47,
};
int scale_qbw_22k[50]={
  34,  35,  36,  37,  38,  38,  39,  40,
  40,  41,  42,  42,  43,  43,  44,  45,
  45,  46,  46,  46,  46,  46,  47,  47,
  47,  47,  47,  47,  47,  47,  47,  47,
  47,  47,  47,  47,  47,  47,  47,  47,
  47,  47,  47,  47,  47,  47,  47,  47,
  47,
};
int scale_qbw_16k[50]={
  33,  34,  35,  36,  37,  38,  39,  40,
  41,  42,  42,  42,  43,  43,  43,  43,
  43,  43,  43,  43,  43,  43,  43,  43,
  43,  43,  43,  43,  43,  43,  43,  43,
  43,  43,  43,  43,  43,  43,  43,  43,
  43,  43,  43,  43,  43,  43,  43,  43,
  43,
};
int scale_qbw_12k[50]={
  37,  38,  39,  40,  41,  42,  42,  43,
  43,  43,  43,  43,  43,  43,  43,  43,
  43,  43,  43,  43,  43,  43,  43,  43,
  43,  43,  43,  43,  43,  43,  43,  43,
  43,  43,  43,  43,  43,  43,  43,  43,
  43,  43,  43,  43,  43,  43,  43,  43,
  43,
};
int scale_qbw_11k[50]={
  38,  39,  40,  41,  42,  42,  43,  43,
  43,  43,  43,  43,  43,  43,  43,  43,
  43,  43,  43,  43,  43,  43,  43,  43,
  43,  43,  43,  43,  43,  43,  43,  43,
  43,  43,  43,  43,  43,  43,  43,  43,
  43,  43,  43,  43,  43,  43,  43,  43,
  43,
};
int scale_qbw_08k[50]={
  39,  39,  39,  39,  39,  39,  39,  39,
  39,  39,  39,  39,  39,  39,  39,  39,
  39,  39,  39,  39,  39,  39,  39,  39,
  39,  39,  39,  39,  39,  39,  39,  39,
  39,  39,  39,  39,  39,  39,  39,  39,
  39,  39,  39,  39,  39,  39,  39,  39,
  39,
};


int scale_qbws_48k[50]={
   5,   5,   5,   6,   6,   6,   6,   6,
   6,   7,   7,   7,   7,   7,   7,   8,
   8,   8,   8,   8,   8,   9,   9,   9,
   9,   9,   9,   9,   9,   9,  10,  10,
  10,  10,  10,  10,  10,  10,  10,  11,
  11,  11,  11,  11,  11,  11,  12,  12,
  12
};
int scale_qbws_44k[50]={
   5,   5,   6,   6,   6,   6,   6,   7,
   7,   7,   7,   7,   8,   8,   8,   8,
   8,   8,   9,   9,   9,   9,   9,   9,
   9,   9,  10,  10,  10,  10,  10,  10,
  10,  10,  11,  11,  11,  11,  11,  11,
  11,  11,  12,  12,  12,  12,  12,  12,
  12
};
int scale_qbws_32k[50]={
   6,   7,   7,   8,   8,   8,   8,   9,
   9,   9,   9,  10,  10,  10,  10,  11,
  11,  11,  11,  11,  12,  12,  12,  12,
  12,  12,  12,  13,  13,  13,  13,  13,
  13,  13,  14,  14,  14,  14,  14,  14,
  14,  14,  14,  14,  14,  14,  14,  14,
  14,
};
int scale_qbws_24k[50]={
   8,   9,   9,  10,  10,  11,  11,  12,
  12,  13,  13,  13,  14,  14,  14,  14,
  15,  15,  15,  15,  15,  15,  15,  15,
  15,  15,  15,  15,  15,  15,  15,  15,
  15,  15,  15,  15,  15,  15,  15,  15,
  15,  15,  15,  15,  15,  15,  15,  15,
  15,
};
int scale_qbws_22k[50]={
   9,  10,  10,  11,  11,  11,  11,  12,
  12,  12,  12,  13,  13,  13,  13,  14,
  14,  14,  14,  14,  15,  15,  15,  15,
  15,  15,  15,  15,  15,  15,  15,  15,
  15,  15,  15,  15,  15,  15,  15,  15,
  15,  15,  15,  15,  15,  15,  15,  15,
  15,
};
int scale_qbws_16k[50]={
  11,  12,  12,  13,  13,  13,  14,  14,
  15,  15,  15,  15,  15,  15,  15,  15,
  15,  15,  15,  15,  15,  15,  15,  15,
  15,  15,  15,  15,  15,  15,  15,  15,
  15,  15,  15,  15,  15,  15,  15,  15,
  15,  15,  15,  15,  15,  15,  15,  15,
  15,
};
int scale_qbws_12k[50]={
  13,  13,  14,  14,  15,  15,  15,  15,
  15,  15,  15,  15,  15,  15,  15,  15,
  15,  15,  15,  15,  15,  15,  15,  15,
  15,  15,  15,  15,  15,  15,  15,  15,
  15,  15,  15,  15,  15,  15,  15,  15,
  15,  15,  15,  15,  15,  15,  15,  15,
  15,
};
int scale_qbws_11k[50]={
  13,  14,  14,  15,  15,  15,  15,  15,
  15,  15,  15,  15,  15,  15,  15,  15,
  15,  15,  15,  15,  15,  15,  15,  15,
  15,  15,  15,  15,  15,  15,  15,  15,
  15,  15,  15,  15,  15,  15,  15,  15,
  15,  15,  15,  15,  15,  15,  15,  15,
  15,
};
int scale_qbws_08k[50]={
  14,  14,  14,  14,  14,  14,  14,  14,
  14,  14,  14,  14,  14,  14,  14,  14,
  14,  14,  14,  14,  14,  14,  14,  14,
  14,  14,  14,  14,  14,  14,  14,  14,
  14,  14,  14,  14,  14,  14,  14,  14,
  14,  14,  14,  14,  14,  14,  14,  14,
  14,
};

static SAM_SCALE_INFO sam_scale_info_bsac[16]={
	{48000, scale_findex_l_48k, scale_findex_s_48k, scale_qbw_48k, scale_qbws_48k},
	{44100, scale_findex_l_44k, scale_findex_s_44k, scale_qbw_44k, scale_qbws_44k},
	{32000, scale_findex_l_32k, scale_findex_s_32k, scale_qbw_32k, scale_qbws_32k},
	{24000, scale_findex_l_24k, scale_findex_s_24k, scale_qbw_24k, scale_qbws_24k},
	{22050, scale_findex_l_22k, scale_findex_s_22k, scale_qbw_22k, scale_qbws_22k},
	{16000, scale_findex_l_16k, scale_findex_s_16k, scale_qbw_16k, scale_qbws_16k},
	{12000, scale_findex_l_12k, scale_findex_s_12k, scale_qbw_12k, scale_qbws_12k},
	{11000, scale_findex_l_11k, scale_findex_s_11k, scale_qbw_11k, scale_qbws_11k},
	{ 8000, scale_findex_l_08k, scale_findex_s_08k, scale_qbw_08k, scale_qbws_08k},
};

#endif /* #ifndef _sam_scale_h_ */
