/**********************************************************************
MPEG-4 Audio VM

This software module was originally developed by
  Y.B. Thomas Kim and S.H. Park (Samsung AIT)
and edited by
  Y.B. Thomas Kim (Samsung AIT) on 1997-11-06

in the course of development of the MPEG-2 NBC/MPEG-4 Audio standard
ISO/IEC 13818-7, 14496-1,2 and 3. This software module is an
implementation of a part of one or more MPEG-2 NBC/MPEG-4 Audio tools
as specified by the MPEG-2 NBC/MPEG-4 Audio standard. ISO/IEC gives
users of the MPEG-2 NBC/MPEG-4 Audio standards free license to this
software module or modifications thereof for use in hardware or
software products claiming conformance to the MPEG-2 NBC/ MPEG-4 Audio
standards. Those intending to use this software module in hardware or
software products are advised that this use may infringe existing
patents. The original developer of this software module and his/her
company, the subsequent editors and their companies, and ISO/IEC have
no liability for use of this software module or modifications thereof
in an implementation. Copyright is not released for non MPEG-2
NBC/MPEG-4 Audio conforming products. The original developer retains
full right to use the code for his/her own purpose, assign or donate
the code to a third party and to inhibit third party from using the
code for non MPEG-2 NBC/MPEG-4 Audio conforming products. This
copyright notice must be included in all copies or derivative works.

Copyright (c) 1997.

**********************************************************************/

#ifndef	_sam_model_h_
#define	_sam_model_h_


static int AModelDim4[50][16]={
	/* Model 2 */
	{  14858, 13706, 12545, 11546, 10434,  9479,  8475,  7619,
	    6457,  5456,  4497,  3601,  2600,  1720,   862,     0,	},

	/* Model 3 */
	{   5476,  4279,  3542,  3269,  2545,  2435,  2199,  2111,
	     850,   739,   592,   550,   165,   132,    21,     0,	},

	/* Model 4 */
	{   4292,  3445,  2583,  2473,  1569,  1479,  1371,  1332,
	     450,   347,   248,   219,    81,    50,    15,     0,	},
	{  15290, 14389, 13434, 12485, 11559, 10627,  9683,  8626,
	    7691,  6727,  5767,  4655,  3646,  2533,  1415,     0,	},
	{  10355,  9160,  7553,  7004,  5671,  4902,  4133,  3433,
	    1908,  1661,  1345,  1222,   796,   714,   233,     0,	},

	/* Model 5 */
	{   3119,  2396,  1878,  1619,  1076,  1051,   870,   826,
	     233,   231,   198,   197,    27,    26,     1,     0,	},
	{   3691,  2897,  2406,  2142,  1752,  1668,  1497,  1404,
	     502,   453,   389,   368,   131,   102,    18,     0,	},
	{  11484, 10106,  7809,  7043,  5053,  3521,  2756,  2603,
	    2296,  2143,  1990,  1531,   765,   459,   153,     0,	},

	/* Model 6 */
	{   2845,  2371,  1684,  1524,   918,   882,   760,   729,
	     200,   198,   180,   178,    27,    25,     1,     0,	},
	{   1621,  1183,   933,   775,   645,   628,   516,   484,
	     210,   207,   188,   186,    39,    35,     1,     0,	},
	{  12603, 12130, 10082,  9767,  8979,  8034,  7404,  6144,
	    4253,  3780,  3150,  2363,  1575,   945,   630,     0,	},
	{   5185,  4084,  3423,  3010,  2406,  2289,  2169,  2107,
	     650,   539,   445,   419,    97,    61,    15,     0,	},
	{  14091, 12522, 11247, 10299,  8928,  7954,  6696,  6024,
	    4766,  4033,  3119,  2508,  1594,  1008,   353,     0,	},

	/* Model 7 */
	{   3833,  3187,  2542,  2390,  1676,  1605,  1385,  1337,
	     468,   434,   377,   349,   117,    93,    30,     0,	},
	{   6621,  5620,  4784,  4334,  3563,  3307,  2923,  2682,
	    1700,  1458,  1213,  1040,   608,   431,   191,     0,	},
	{  12027, 11572,  9947,  9687,  9232,  8126,  7216,  6176,
	    4161,  3705,  3055,  2210,  1235,   780,   455,     0,	},
	{  14363, 13143, 12054, 11153, 10220,  9388,  8609,  7680,
	    6344,  5408,  4578,  3623,  2762,  1932,  1099,     0,	},
	{  13856, 12350, 11151, 10158,  8816,  7913,  6899,  6214,
	    4836,  4062,  3119,  2505,  1624,  1020,   378,     0,	},

	/* Model 8 */
	{   2770,  2075,  1635,  1511,  1059,  1055,   928,   923,
	     204,   202,   190,   188,     9,     8,     1,     0,	},
	{   1810,  1254,  1151,  1020,   788,   785,   767,   758,
	     139,   138,   133,   132,    14,    13,     1,     0,	},
	{  13263, 10922, 10142,  9752,  8582,  7801,  5851,  5071,
	    3510,  3120,  2730,  2340,  1560,   780,   390,     0,	},
	{   2600,  1762,  1459,  1292,   989,   983,   921,   916,
	     238,   233,   205,   202,    32,    30,     3,     0,	},
	{  14866, 12983, 11297, 10398,  9386,  8683,  7559,  6969,
	    5451,  4721,  3484,  3007,  1882,  1208,   590,     0,	},
	{   6155,  5057,  4328,  3845,  3164,  2977,  2728,  2590,
	    1341,  1095,   885,   764,   303,   188,    74,     0,	},
	{  14536, 13348, 11819, 11016,  9340,  8399,  7135,  6521,
	    5114,  4559,  3521,  2968,  1768,  1177,   433,     0,	},

	/* Model 9 */
	{   3383,  2550,  1967,  1794,  1301,  1249,  1156,  1118,
	     340,   298,   247,   213,    81,    54,    15,     0,	},
	{   7348,  6275,  5299,  4935,  3771,  3605,  2962,  2814,
	    1295,  1143,   980,   860,   310,   230,    75,     0,	},
	{  12503,  9701,  8838,  8407,  6898,  6036,  4527,  3664,
	    2802,  2586,  2371,  2155,  1293,   431,   215,     0,	},
	{  11210,  9646,  8429,  7389,  6252,  5746,  5140,  4692,
	    3350,  2880,  2416,  2014,  1240,   851,   404,     0,	},
	{  14988, 13408, 11860, 10854,  9631,  8992,  7834,  7196,
	    5616,  4793,  3571,  2975,  1926,  1212,   627,     0,	},
	{  14152, 13258, 12486, 11635, 11040, 10290,  9740,  8573,
	    7546,  6643,  5903,  4928,  4005,  2972,  1751,     0,	},
	{  14817, 13545, 12244, 11281, 10012,  8952,  7959,  7136,
	    5791,  4920,  3997,  3126,  2105,  1282,   623,     0,	},

	/* Model 10 */
	{   2335,  1613,  1371,  1277,   901,   892,   841,   833,
	     141,   140,   130,   129,    24,    23,     1,     0,	},
	{   1746,  1251,  1038,   998,   615,   611,   583,   582,
	     106,   104,   101,    99,     3,     2,     1,     0,	},
	{  13010, 12047, 11565, 11083,  9637,  8673,  6264,  5782,
	    4336,  3855,  3373,  2891,  2409,  1927,   963,     0,	},
	{   2137,  1660,  1471,  1312,  1007,  1000,   957,   951,
	     303,   278,   249,   247,    48,    47,     1,     0,	},
	{  13360, 12288, 10727,  9752,  8484,  7899,  7119,  6631,
	    5363,  3900,  3023,  2535,  1852,  1267,   585,     0,	},
	{   4124,  3181,  2702,  2519,  1959,  1922,  1733,  1712,
	     524,   475,   425,   407,    78,    52,    15,     0,	},
	{  14541, 13343, 11637, 10862,  9328,  8783,  7213,  6517,
	    5485,  5033,  4115,  3506,  2143,  1555,   509,     0,	},
	{   9845,  8235,  7126,  6401,  5551,  5131,  4664,  4320,
	    2908,  2399,  1879,  1506,   935,   603,   277,     0,	},
	{  14766, 13685, 12358, 11442, 10035,  9078,  7967,  7048,
	    5824,  5006,  4058,  3400,  2350,  1612,   659,     0,	},

	/* Model 11 */
	{   2872,  2294,  1740,  1593,  1241,  1155,  1035,   960,
	     339,   300,   261,   247,   105,    72,    34,     0,	},
	{   3854,  3090,  2469,  2276,  1801,  1685,  1568,  1505,
	     627,   539,   445,   400,   193,   141,    51,     0,	},
	{  11419, 11170, 10922, 10426,  7943,  6950,  3723,  3475,
	    1737,  1489,  1241,   992,   744,   496,   248,     0,	},
	{   9505,  8070,  6943,  6474,  5305,  5009,  4290,  4029,
	    2323,  1911,  1591,  1363,   653,   443,   217,     0,	},
	{  13472, 12295, 10499,  9167,  7990,  7464,  6565,  6008,
	    4614,  3747,  2818,  2477,  1641,  1084,   557,     0,	},
	{  14182, 12785, 11663, 10680,  9601,  8758,  8135,  7353,
	    6014,  5227,  4433,  3727,  2703,  1818,   866,     0,	},
	{  15068, 13770, 12294, 11213, 10230,  9266,  8439,  7438,
	    6295,  5368,  4361,  3620,  2594,  1797,   895,     0,	},
	{  15173, 14794, 14359, 13659, 13224, 12600, 11994, 11067,
	   10197,  9573,  9081,  7624,  6697,  4691,  3216,     0,	},
	{  14873, 13768, 12458, 11491, 10229,  9164,  7999,  7186,
	    5992,  5012,  4119,  3369,  2228,  1427,   684,     0,	},
};

static int AModelDim3[40][8]={
	/* Model 4 */
	{  15139, 13484, 11909,  9716,  8068,  5919,  3590,     0, },
	{   8328,  6615,  4466,  3586,  1759,  1062,   321,     0, },

	/* Model 5 */
	{  11106,  8393,  6517,  4967,  2739,  2200,   608,     0, },
	{  10628,  8930,  6618,  4585,  2858,  2129,   796,     0, },

	/* Model 6 */
	{   8800,  6734,  4886,  3603,  1326,  1204,   104,     0, },
	{  10410,  8922,  5694,  4270,  2656,  1601,   533,     0, },
	{  13514, 11030,  8596,  6466,  4345,  3250,  1294,     0, },
	{  12596, 10427,  7608,  6003,  3782,  2580,   928,     0, },

	/* Model 7 */
	{  11369,  9466,  7519,  6138,  3544,  2441,  1136,     0, },
	{   9566,  7943,  4894,  3847,  2263,  1596,   562,     0, },
	{  14785, 13256, 11596,  9277,  7581,  5695,  3348,     0, },
	{  12083,  9880,  7293,  5875,  3501,  2372,   828,     0, },

	/* Model 8 */
	{   7113,  4895,  3698,  3193,  1096,   967,    97,     0, },
	{  12675, 11275,  7946,  6356,  4086,  2875,  1097,     0, },
	{  10797,  8840,  6149,  5050,  2371,  1697,   483,     0, },
	{  12611, 10374,  8025,  6167,  4012,  2608,   967,     0, },
	{  12802, 10407,  8142,  6263,  3928,  3013,  1225,     0, },
	{  12735, 10606,  7861,  6011,  3896,  2637,   917,     0, },

	/* Model 9 */
	{   9531,  7809,  5972,  4892,  2774,  1782,   823,     0, },
	{  11268,  9422,  6508,  5277,  3076,  2460,  1457,     0, },
	{  12143, 10250,  7784,  6445,  3954,  2528,  1228,     0, },
	{  12485, 10041,  7461,  5732,  3669,  2361,   940,     0, },
	{  14895, 13534, 12007,  9787,  8063,  5761,  3570,     0, },
	{  12873, 10678,  8257,  6573,  4186,  2775,  1053,     0, },

	/* Model 10 */
	{   7110,  5230,  4228,  3552,   686,   622,    46,     0, },
	{  10838, 10132,  8318,  7158,  5595,  3428,  2318,     0, },
	{   9327,  7413,  5073,  4391,  2037,  1695,   205,     0, },
	{  13742, 11685,  8977,  7230,  5015,  3426,  1132,     0, },
	{  10829,  8581,  6285,  4865,  2539,  1920,   594,     0, },
	{  13010, 11143,  8682,  7202,  4537,  3297,  1221,     0, },
	{  13070, 11424,  9094,  7203,  4771,  3479,  1486,     0, },
	{  13391, 11189,  8904,  7172,  4966,  3183,  1383,     0, },

	/* Model 11 */
	{  10654,  8555,  6875,  4976,  3286,  2229,   826,     0, },
	{  11013,  9245,  6730,  4962,  3263,  1699,   883,     0, },
	{  11639,  9520,  7523,  6260,  4012,  2653,  1021,     0, },
	{  13099, 10826,  8476,  6915,  4488,  2966,  1223,     0, },
	{  13654, 11814,  9714,  7856,  5717,  3916,  2112,     0, },
	{  13120, 10879,  8445,  6665,  4356,  2794,  1047,     0, },
	{  15328, 13985, 12748, 10084,  8587,  6459,  4111,     0, },
	{  13063, 10913,  8477,  6752,  4529,  3047,  1241,     0, }
};

static int AModelDim2[40][4]={
	/* Model 4 */
	{  14008, 10384,  6834,     0, },
	{   4631,  2696,   793,     0, },

	/* Model 5 */
	{  10771,  6410,  2619,     0, },
	{   7596,  4499,  1512,     0, },

	/* Model 6 */
	{   8869,  5163,  1078,     0, },
	{   8459,  5107,  1670,     0, },
	{  13231,  8754,  4635,     0, },
	{  10008,  6213,  2350,     0, },

	/* Model 7 */
	{  11083,  7446,  3439,     0, },
	{   7212,  4217,  1240,     0, },
	{  14050, 10293,  6547,     0, },
	{   8773,  5285,  1799,     0, },

	/* Model 8 */
	{   6858,  4547,   631,     0, },
	{   9473,  5781,  1840,     0, },
	{  10571,  6942,  2445,     0, },
	{  10043,  6306,  2373,     0, },
	{  13131,  9420,  4928,     0, },
	{   9831,  5972,  2251,     0, },

	/* Model 9 */
	{  11455,  7068,  3383,     0, },
	{   7631,  4565,  1506,     0, },
	{  10891,  7210,  3874,     0, },
	{   9342,  5547,  1963,     0, },
	{  14088, 10108,  6749,     0, },
	{   9969,  6059,  2363,     0, },

	/* Model 10 */
	{   6101,  2575,   265,     0, },
	{   8209,  5197,  1287,     0, },
	{   8658,  5404,  1628,     0, },
	{  10402,  6691,  2828,     0, },
	{  11074,  7282,  3092,     0, },
	{   9941,  5861,  2191,     0, },
	{  13169,  9298,  5406,     0, },
	{  10280,  6372,  2633,     0, },

	/* Model 11 */
	{  10569,  6180,  2695,     0, },
	{   6969,  4370,  1366,     0, },
	{  12453,  8284,  4722,     0, },
	{   9212,  5772,  2053,     0, },
	{  12497,  8501,  4969,     0, },
	{   9311,  5578,  1793,     0, },
	{  14661, 11179,  7924,     0, },
	{  10101,  6369,  2615,     0, }
};

static int AModelDim1[40][2]={
	/* Model 4 */
	{  11228,     0, },
	{    980,     0, },

	/* Model 5 */
	{   6112,     0, },
	{   4155,     0, },

	/* Model 6 */
	{   3575,     0, },
	{   4003,     0, },
	{   9876,     0, },
	{   5614,     0, },

	/* Model 7 */
	{   8823,     0, },
	{   3269,     0, },
	{  10948,     0, },
	{   4452,     0, },

	/* Model 8 */
	{   4028,     0, },
	{   3597,     0, },
	{   7864,     0, },
	{   5766,     0, },
	{  10395,     0, },
	{   4944,     0, },

	/* Model 9 */
	{   9437,     0, },
	{   2639,     0, },
	{   9537,     0, },
	{   5140,     0, },
	{  11041,     0, },
	{   5694,     0, },

	/* Model 10 */
	{   1489,     0, },
	{   4954,     0, },
	{   5660,     0, },
	{   5298,     0, },
	{   8045,     0, },
	{   5340,     0, },
	{  10371,     0, },
	{   5419,     0, },

	/* Model 11 */
	{   6971,     0, },
	{   3166,     0, },
	{   9182,     0, },
	{   4244,     0, },
	{  10296,     0, },
	{   4695,     0, },
	{  11399,     0, },
	{   5359,     0, }
};

static int AModelDifScf0[55] = {
   8192,  6144,  5120,  4096,  3072,  2560,  2048,  1792, 
   1536,  1280,  1024,   896,   768,   640,   576,   512, 
    448,   384,   320,   288,   256,   224,   192,   176, 
    160,   144,   128,   112,    96,    88,    80,    72, 
     64,    56,    48,    44,    40,    36,    32,    28, 
     24,    22,    20,    18,    16,    14,    13,    12, 
     11,    10,     9,     8,     7,     6,     0
};


static int AModelDifScf1[67] = {
  15018, 13653, 12288, 10922, 10240,  9557,  8874,  8192, 
   7509,  6826,  6144,  5802,  5461,  5120,  4949,  4778,
   4608,  4437,  4266,  4096,  3925,  3840,  3754,  3669,
   3584,  3498,  3413,  3328,  3242,  3157,  3072,  2986,
   2901,  2816,  2730,  2645,  2560,  2474,  2389,  2304,
   2218,  2133,  2048,  1962,  1877,  1792,  1706,  1621,
   1536,  1450,  1365,  1280,  1194,  1109,  1024,   938,
    853,   768,   682,   597,   512,   426,   341,   256,
    170,    85,     0
};

static int AModelDifScf2[8]={
    1342,   790,   510,   344,   214,   127,    57,     0
};

static int AModelDifScf3[16]={
    2441,  2094,  1798,  1563,  1347,  1154,   956,   818,
     634,   464,   342,   241,   157,    97,    55,     0
};

static int AModelDifScf4[32]={
    3963,  3525,  3188,  2949,  2705,  2502,  2286,  2085,
    1868,  1668,  1515,  1354,  1207,  1055,   930,   821,
     651,   510,   373,   269,   192,   134,    90,    58,
      37,    29,    24,    15,    10,     8,     5,     0
};

static int AModelDifScf5[64]={
    13587, 13282, 12961, 12656, 12165, 11721, 11250, 10582,
    10042,  9587,  8742,  8010,  7256,  6619,  6042,  5480,
     4898,  4331,  3817,  3374,  3058,  2759,  2545,  2363,
     2192,  1989,  1812,  1582,  1390,  1165,  1037,   935,
      668,   518,   438,   358,   245,   197,   181,   149,
      144,   128,   122,   117,   112,   106,   101,    85,
       80,    74,    69,    64,    58,    53,    48,    42,
       37,    32,    26,    21,    16,    10,     5,     0
};

static int AModelDiffAModel0[4]={
	9868,  3351,  1676,     0
};

static int AModelDiffAModel1[8]={
	12492,  8600,  5941,  3282,  2155,  1028,   514,     0
};


static int AModelDiffAModel2[16]={
	14316, 12248,  9882,  7516,  6399,  5282,  4183,  3083,
	 2247,  1411,   860,   309,   185,    61,    31,     0
};

static int AModelDiffAModel3[40]={
    12170,  7956,  6429,  4901,  4094,  3287,  2982,  2677,
     2454,  2230,  2062,  1894,  1621,  1348,  1199,  1050,
      854,   658,   468,   278,   169,    59,    38,    18,
       17,    14,    13,    12,    11,    10,     9,     8,
        7,     6,     5,     4,     3,     2,     1,     0
};

static int	AModelStereoInfo[4]={
	13926, 4096, 1638, 0
};

static int AModelMsUsed[2]={
	11469, 0
};

static int AModelSign[2]={
	8192, 0
};

static int AModelNoiseFlag[2]={
	8192, 0
};

static int	AModelNoiseMode[4]={
	12288, 8192, 4096, 0
};

#endif /* #ifndef _sam_model_h_ */
