/**********************************************************************
MPEG-4 Audio VM

This software module was originally developed by
  Y.B. Thomas Kim and S.H. Park (Samsung AIT)
and edited by
  Y.B. Thomas Kim (Samsung AIT) on 1997-11-06

in the course of development of the MPEG-2 NBC/MPEG-4 Audio standard
ISO/IEC 13818-7, 14496-1,2 and 3. This software module is an
implementation of a part of one or more MPEG-2 NBC/MPEG-4 Audio tools
as specified by the MPEG-2 NBC/MPEG-4 Audio standard. ISO/IEC gives
users of the MPEG-2 NBC/MPEG-4 Audio standards free license to this
software module or modifications thereof for use in hardware or
software products claiming conformance to the MPEG-2 NBC/ MPEG-4 Audio
standards. Those intending to use this software module in hardware or
software products are advised that this use may infringe existing
patents. The original developer of this software module and his/her
company, the subsequent editors and their companies, and ISO/IEC have
no liability for use of this software module or modifications thereof
in an implementation. Copyright is not released for non MPEG-2
NBC/MPEG-4 Audio conforming products. The original developer retains
full right to use the code for his/her own purpose, assign or donate
the code to a third party and to inhibit third party from using the
code for non MPEG-2 NBC/MPEG-4 Audio conforming products. This
copyright notice must be included in all copies or derivative works.

Copyright (c) 1997.

**********************************************************************/

#ifndef _sam_dec_h_
#define _sam_dec_h_

#include "common.h"
#include "bitstream.h"
#include "tf_main.h"
#include "sam_tns.h"
#include "tns.h"

#ifdef __cplusplus
extern "C" {
#endif


  void my_debug(char *str);
  /* --- Init BSAC-decoder --- */
  void sam_decode_init(int sampling_rate_decoded, int block_size_samples);
  void sam_scale_bits_init(int sampling_rate_decoded, int block_size_samples);

  /* ----- Decode one frame with the BSAC-decoder  ----- */
  int     sam_decode_frame(
                           BsBitStream *fixed_stram,
                           BsBitStream *gc_sttram[MAX_TIME_CHANNELS],
                           int     target_br,
                           double  **coef,
                           int     *block_type,
                           Window_shape *window_Shape);

/*
int     sam_decode_core_frame_init ( BsBitStream* fixed_stream, int core_coder_present);
*/

int     sam_decode_core_frame ( BsBitStream* fixed_stream,
                               int          target_br,
                               double**     coef,
                               WINDOW_TYPE  block_type,
                               int          max_sfb,
                               int          gInfo,
                               int          stereo_mode,
                               int          msMask[8][60],
                               int          ubits,
                               int          core_used_bits,
                               int          AUlength,
                               int          n_chan_core_bsac);

  int     sam_decode_core_bsac ( BsBitStream* fixed_stream,
                                 int          target_br,
                                 double**     coef,
                                 WINDOW_TYPE  block_type,
                                 Window_shape window_Shape,
                                 int          max_sfb,
                                 int          gInfo,
                                 int          core_used_bits,
                                 int          n_chan_core_bsac );

  void sam_decode_bsac_data(int          target_br,
                           int          frameLength,
                           int          encodedLayer,
                           int          core_used_bits,
                           int          stereo_mode,
                           WINDOW_TYPE  windowSequence[],
                           int          scalefactors[][136],
                           int          groupInfo[][7],
                           int          samples[][1024],
                           int          maxSfb[],
                           int          ms_mask[],
                           int          is_info[],
                           int          *pns_sfb_start,
                           int          pns_sfb_flag[][136],
                           int          pns_sfb_mode[],
						   int          block_size_samples,
                           int          nch);

  void sam_decode_bsac_stream ( WINDOW_TYPE windowSequence[],
                                int         target,
                                int         frameLength,
                                int         encodedLayer,
                                int         core_used_bits,
                                int         samples[][1024],
                                int         scalefactors[][136],
                                int         maxSfb[],
                                int         groupInfo[][7],
                                int         ms_mask[],
                                int         stereo_mode,
                                int         is_info[],
                                int         *pns_sfb_start,
                                int         pns_sfb_flag[][136],
                                int         pns_sfb_mode[],
                                int         swb_offset[][136],
						        int         block_size_samples,
                                int         nch );

  void sam_dequantization(int target_br,
                          int windowSequence,
                          int scalefactors[],
                          int groupInfo[],
                          int samples[],
                          int maxSfb,
                          int     is_info[],
                          float spectrums[],
                          int ch);

  void sam_intensity(int windowSequence,
                     int     groupInfo[],
                     float spectrum[][1024],
                     int     factors[][136],
                     int is_info[], 
                     int     ms_mask[],
                     int     pred[][60],
                     int     maxSfb);

  void sam_ms_stereo(int windowSequence,
                     int groupInfo[],
                     float spectrum[][1024],
                     int ms_mask[],
                     int maxSfb);

  void sam_pns(int windowSequence,
                     int groupInfo[],
                     int maxSfb,
					 int pns_sfb_flag[][136],
					 int pns_sfb_mode[],
                     float spectrum[][1024],
                     int scalefactors[][136],
                     int predict_data[][60],
                     int nch);

  int  sam_pred_max_bands();
  void sam_prediction(int windowSequence, int lpflag[], float coef[], int ch);
  void sam_predict(int windowSequence, int lpflag[], float coef[], int sfb[], int ch);
  void sam_predict_reset(int windowSequence, int prstflag[], int ch);
  void sam_predict_pns_reset(int windowSequence, int maxSfb, int pns_sfb_flag[], int ch);
  void sam_predict_pns_reset1(int maxSfb, int pns_sfb_flag[], int swb_offset[], int ch);

  void sam_tns_data(int windowSequence, int maxSfb, float spect[1024], sam_TNS_frame_info *tns);
  int sam_tns_max_bands(int windowSequence);
  int sam_tns_max_order(int windowSequence);
  void sam_tns_decode_subblock(int windowSequence, float *spec, int maxSfb, int *sfbs, sam_TNSinfo *tns_info);

  int sam_get_region_info(int *groupInfo, int *startRegion, int *endRegion);

  void sam_start_decoding(int , int);
  int sam_decode_symbol(int *, int *, double *);

  int sam_i2cb(int ch, int i);
  void sam_setBsacdec2BitBuffer(BsBitStream *fixed_stream);
  long sam_GetBits(int n);
  int sam_getUsedBits(void);
  void sam_predinit(void);

#ifdef __cplusplus
           }
#endif

#endif /* #ifndef       _sam_dec_h_ */
