/*****************************************************************************
 *                                                                           *
"This software module was originally developed by 

Ralph Sperschneider (Fraunhofer Gesellschaft IIS)

in the course of development of the MPEG-2 NBC/MPEG-4 Audio standard ISO/IEC 13818-7, 
14496-1,2 and 3. This software module is an implementation of a part of one or more 
MPEG-2 NBC/MPEG-4 Audio tools as specified by the MPEG-2 NBC/MPEG-4 
Audio standard. ISO/IEC  gives users of the MPEG-2 NBC/MPEG-4 Audio 
standards free license to this software module or modifications thereof for use in 
hardware or software products claiming conformance to the MPEG-2 NBC/MPEG-4
Audio  standards. Those intending to use this software module in hardware or 
software products are advised that this use may infringe existing patents. 
The original developer of this software module and his/her company, the subsequent 
editors and their companies, and ISO/IEC have no liability for use of this software 
module or modifications thereof in an implementation. Copyright is not released for 
non MPEG-2 NBC/MPEG-4 Audio conforming products.The original developer
retains full right to use the code for his/her  own purpose, assign or donate the 
code to a third party and to inhibit third party from using the code for non 
MPEG-2 NBC/MPEG-4 Audio conforming products. This copyright notice must
be included in all copies or derivative works." 
Copyright(c)1996.
 *                                                                           *
 ****************************************************************************/ 
 
#ifndef _reorderspec_h_
#define _reorderspec_h_

#ifdef VERSION2
#define UINT_BITLENGTH            32    /* Length in bits of an (unsigned) long variable */
#include "interface.h"
#include "bitfct.h"
#include "buffers.h"
#include "resilience.h"

#define MAX_NR_PCW               200    /* maximum allowed nr of priority Codewords */
#include "interface.h"
#include "bitfct.h"
#include "buffers.h"
#endif /*VERSION2*/

typedef struct tag_hcr *HANDLE_HCR;

#ifdef VERSION2
/*** T_HCR ****/
HANDLE_HCR     CreateHcrInfo ( );

unsigned short GetLenOfLongestCw ( HANDLE_HCR hHcrInfo );

unsigned short GetLenOfSpecData ( HANDLE_HCR hHcrInfo );

unsigned short GetReorderStatusFlag ( HANDLE_HCR hHcrInfo );

void           InitHcrInfo ( HANDLE_HCR hHcrInfo );

void           ReadLenOfLongestCw ( HANDLE_HCR        handle, 
                                    HANDLE_RESILIENCE hResilience,
                                    HANDLE_BUFFER     hVm, 
                                    HANDLE_EP_INFO    hEPInfo );

void           ReadLenOfSpecData ( HANDLE_HCR        handle, 
                                   HANDLE_RESILIENCE hResilience,
                                   HANDLE_BUFFER     hVm, 
                                   HANDLE_EP_INFO    hEPInfo );

/*** T_HCR end ***/
void           CheckDecodingProgress ( HANDLE_BUFFER  hSpecData,
                                       HANDLE_RESILIENCE hResilience,
                                       HANDLE_HCR     hHcrInfo,
                                       HANDLE_EP_INFO hEPInfo );

HANDLE_BUFFER GetNonPcwBufPtrHdl ( HANDLE_HCR hHcrInfo );

void           InitHcr ( HANDLE_BUFFER hSpecData, 
                         HANDLE_HCR    hHcrInfo );

unsigned char  GetCurrentMaxCodewordLength ( unsigned short maxCWLen, 
                                             HANDLE_HCR     hHcrInfo );

void           ReorderSpec ( unsigned char     codewordLength, 
                             int*              qp,
                             unsigned char*    qpStatus, 
                             int               table, 
                             unsigned char     maxCWLength, 
                             int               step, 
                             HANDLE_RESILIENCE hResilience,
                             HANDLE_BUFFER     hSpecData,
                             HANDLE_HCR        hHcrInfo,
                             HANDLE_EP_INFO    hEPInfo );

void           ReorderSpecDecPCWFinishedCheck ( unsigned short maxCWLength,
                                               HANDLE_BUFFER  hSpecData,
                                               HANDLE_RESILIENCE hResilience,
                                               HANDLE_HCR     hHcrInfo,
                                               HANDLE_EP_INFO hEPInfo );

#endif /*VERSION2*/

#endif /* _reorderspec_h_  */
