/*****************************************************************************/
/* This software module was originally developed by                          */
/*   Akio Jin (NTT),                                                         */
/*   Takeshi Norimatsu,                                                      */
/*   Mineo Tsushima,                                                         */
/*   and Tomokazu Ishikawa (Matsushita Electric Industrial Co Ltd.)          */
/* and edited by                                                             */
/*   Naoki Iwakami (NTT) on 1997-04-18,                                      */
/*   Naoki Iwakami (NTT) on 1997-07-17,                                      */
/*   Akio Jin (NTT),                                                         */
/*   Mineo Tsushima, (Matsushita Electric Industrial Co Ltd.)                */
/*   and Tomokazu Ishikawa (Matsushita Electric Industrial Co Ltd.)          */
/*   on 1997-10-23,                                                          */
/* in the course of development of the                                       */
/* MPEG-2 NBC/MPEG-4 Audio standard ISO/IEC 13818-7, 14496-1,2 and 3.        */
/* This software module is an implementation of a part of one or more        */
/* MPEG-2 NBC/MPEG-4 Audio tools as specified by the MPEG-2 NBC/MPEG-4 Audio */
/* standard. ISO/IEC  gives users of the MPEG-2 NBC/MPEG-4 Audio standards   */
/* free license to this software module or modifications thereof for use in  */
/* hardware or software products claiming conformance to the MPEG-2 NBC/     */
/* MPEG-4 Audio  standards. Those intending to use this software module in   */
/* hardware or software products are advised that this use may infringe      */
/* existing patents. The original developer of this software module and      */
/* his/her company, the subsequent editors and their companies, and ISO/IEC  */
/* have no liability for use of this software module or modifications        */
/* thereof in an implementation. Copyright is not released for non           */
/* MPEG-2 NBC/MPEG-4 Audio conforming products. The original developer       */
/* retains full right to use the code for his/her  own purpose, assign or    */
/* donate the code to a third party and to inhibit third party from using    */
/* the code for non MPEG-2 NBC/MPEG-4 Audio conforming products.             */
/* This copyright notice must be included in all copies or derivative works. */
/* Copyright (c)1997.                                                        */
/*****************************************************************************/


/*---------------------------------------------------------------------------*/
/* twinvq.h                                                                  */
/* Header file of TwinVQ audio coding program                                */
/*---------------------------------------------------------------------------*/

#define ntt_NSclLay_MAX  8   /* Maximum number of scale layers */
#define ntt_NSclLay_BITS 4  /* Number of bits for layers information */
#define mat_SHIFT_BIT 2 /* Matsushita Electric Industrial(Tomokazu Ishikawa) */

#define ntt_BLIM_BITS 4     /* Number of bits for bandwidth information */
enum ntt_BANDWIDTH_ID {
  ntt_BW_0 = 0,
  ntt_BW_p1,
  ntt_BW_p2,
  ntt_BW_p3,
  ntt_BW_p4,
  ntt_BW_p5,
  ntt_BW_p6,
  ntt_BW_p7,
  ntt_BW_p8,
  ntt_BW_p9,
  ntt_BW_1p0,
  ntt_BW_1_6,
  ntt_BW_1_3,
  ntt_BW_2_3,
  ntt_BW_5_6
};
 
#define ntt_IBPS_BITS_SCL 16 /* bitrate for scalable coder */

/*---------------------------------------------------------------------------*/
/* POST FILTER                                                               */
/*---------------------------------------------------------------------------*/
#define ntt_POSTFILT_SCL   YES

/*---------------------------------------------------------------------------*/
/* BIRATE CONTROL                                                           */
/*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*/
/************************  PARAMETER TABLES **********************************/
/*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*/

typedef struct {
    double band_exp;	   /* Lagwindow band expansion factor (Hz)     */
    int    gain_bits;      /* Gain quantization bits                   */
    double amp_max;        /* Maximum gain                             */
    int    sub_gain_bits;  /* Sub gain quantization bits               */
    double sub_amp_max;    /* Maximum sub-gain                         */
    double mu;             /* mu factor of mu-law gain coding          */
    int    n_pr;	   /* LPC order                                */
    char   *lspcodebook;   /* LSP codebook name                        */ 
    int    lsp_bit0;	   /* num of bits for prediction switch        */
    int    lsp_bit1;	   /* num of bits at first stage               */
    int    lsp_bit2;	   /* num of bits per split vq at second stage */
    int    lsp_split;	   /* num of split at second stage             */
    char   *fw_cb_name;	   /* Env. codebook name                       */
    char   *fw_cb_name_s;  /* Env. codebook name                       */
    char   *fw_cb_name_m;  /* Env. codebook name                       */
    int    fw_n_div;	   /* Number of division of envelope codebook  */
    int    fw_n_div_s;	   /* Num. div. of env. cb (short frame)       */
    int    fw_n_div_m;	   /* Num. div. of env. cb (medium frame)      */
    int    fw_n_bit;	   /* Envelope codebook bits                   */
    int    fw_n_bit_s;	   /* Envelope codebook bits (short)           */
    int    fw_n_bit_m;	   /* Envelope codebook bits (short)           */
    char   *cb_name0;	   /* shape codebook (long 0)                  */
    char   *cb_name1;	   /* shape codebook (long 1)                  */
    char   *cb_name2;	   /* shape codebook (short 0)                 */
    char   *cb_name3;	   /* shape codebook (short 1)                 */
    char   *cb_name4;	   /* shape codebook (medium 1)                */
    char   *cb_name5;	   /* shape codebook (medium 1)                */
    int    n_can;	   /* pre-selection candidates                 */
    int    n_can_s;	   /* pre-selection candidates (short frame)   */
    int    n_can_m;	   /* pre-selection candidates (short frame)   */
} ntt_MODE_TABLE_SCL;


#ifdef ntt_MAIN_ROUTINE

ntt_MODE_TABLE_SCL ntt_mode_24_16_scl ={ /* 24kHz-8+8kbit/s */
    480.0,
    8,
    8000.,
    4,
    6000.,
    100.,
    20,
    "./tables/tf_vq_tbls/20b19s48_scl1.ssp",
    1,
    6,
    4,
    3,
    "./tables/tf_vq_tbls/fcd4808_scl",
    "./tables/tf_vq_tbls/fcd4808s_scl",
    "./tables/tf_vq_tbls/fcd4808m_scl",
    8/*7*/,
    1,
    2,
    6,
    0,
    0,
    "./tables/tf_vq_tbls/cd4808_0_scl",
    "./tables/tf_vq_tbls/cd4808_1_scl",
    "./tables/tf_vq_tbls/cd4808_2_scl",
    "./tables/tf_vq_tbls/cd4808_3_scl",
    "./tables/tf_vq_tbls/cd4808_4_scl",
    "./tables/tf_vq_tbls/cd4808_5_scl",
    6,
    6,
    6};

ntt_MODE_TABLE_SCL ntt_mode_24_24_scl ={ /* 24kHz-8+8+8kbit/s */
    480.0,
    7,
    8000.,
    4,
    6000.,
    100.,
    20,
    "./tables/tf_vq_tbls/20b19s48_scl2.ssp",
    1,
    6,
    4,
    3,
    "./tables/tf_vq_tbls/fcd4808_scl2",
    "./tables/tf_vq_tbls/fcd4808s_scl2",
    "./tables/tf_vq_tbls/fcd4808m_scl2",
    8,
    1,
    2,
    6,
    0,
    0,
    "./tables/tf_vq_tbls/cd4808_0_scl2",
    "./tables/tf_vq_tbls/cd4808_1_scl2",
    "./tables/tf_vq_tbls/cd4808_2_scl2",
    "./tables/tf_vq_tbls/cd4808_3_scl2",
    "./tables/tf_vq_tbls/cd4808_4_scl2",
    "./tables/tf_vq_tbls/cd4808_5_scl2",
    6,
    6,
    6};

#else
extern ntt_MODE_TABLE_SCL ntt_mode_48_16_scl;
extern ntt_MODE_TABLE_SCL ntt_mode_48_24_scl;
extern ntt_MODE_TABLE_SCL ntt_mode_24_16_scl;
extern ntt_MODE_TABLE_SCL ntt_mode_24_24_scl;
#endif


/*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*/
/****************************  FUNCTIONS  ************************************/
/*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*/

#ifdef __cplusplus
extern "C" {
#endif

void ntt_scale_message(int iscl);

void ntt_scale_tf_requantize_spectrum(/* Input */
				      ntt_INDEX *indexp,
				      /* Output */
				      double flat_spectrum[],
				      /* scalable layer ID */
				      int iscl);

void ntt_scale_tf_proc_spectrum_d(/* Input */
				  ntt_INDEX  *indexp,
				  double flat_spectrum[],
				  /* Output */
				  double spectrum[],
				  int iscl);

void ntt_scale_init(int iscl, int cb_lyr);

void ntt_scale_cp_mdtbl(ntt_MODE_TABLE_SCL ltbl, int iscl);

void ntt_scale_dec_bark_env(/* Parameters */
                      int    nfr,
                      int    nsf,
                      int    n_ch,
                      double *codebook,
                      int    ndiv,
                      int    cv_len,
                      int    cv_len_max,
                      int    *bark_tbl,
                      int    n_crb,
                      double alf_step,
                      double *penv_tmp,
                      /* Input */
                      int    index_fw[],
                      int    index_fw_alf[],
                      int    pf_switch,
                      /* Output */
                      double bark_env[],
                      double band_lower[]); /*In*/

void ntt_dec_sq_gain( /* Input */
                  int     index_pow,
                  double  amp_max,
                  double  mu,
                  double  step,
                  double  amp_nm,
                     /* Output */
                  double  *gain);


int mat_scale_set_shift_para(int a);
int mat_scale_set_shift_para2(int a);
void mat_scale_tf_requantize_spectrum(/* Input */
                                      ntt_INDEX *indexp,
                                      /* Output */
                                      double flat_spectrum[],
                                      /* scalable layer ID */
                                      int iscl);

#ifdef __cplusplus
}
#endif


/*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*/
/**********************  EXTERNAL VARIABLES  *********************************/
/*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*/

#define LX (ntt_NSclLay_MAX)


#ifdef ntt_MAIN_ROUTINE

/*---------------------------------------------------------------------------*/
/* PROGRAM MODE                                                              */
/*---------------------------------------------------------------------------*/
double ntt_AC_TOP[LX][ntt_N_SUP_MAX][4];
double ntt_AC_BTM[LX][ntt_N_SUP_MAX][4];

int    ntt_NSclLay;         /* number of scale layers */

int    ntt_IBPS_SCL[LX];    /* ID number of bitrate  */
double ntt_BPS_SCL[LX];     /* bitrate */

double ntt_BAND_UPPER_SCL[LX], ntt_BAND_LOWER_SCL[LX]; /* band limit */
int    ntt_BAND_UPPER_ID_SCL[LX], ntt_BAND_LOWER_ID_SCL[LX]; /* band ID */

/* band limit mode table */
double b_lim_tbl[] ={
  0.0,      /* mode  0 */
  0.1,      /* mode  1 */
  0.2,      /* mode  2 */
  0.3,      /* mode  3 */
  0.4,      /* mode  4 */
  0.5,      /* mode  5 */
  0.6,      /* mode  6 */
  0.7,      /* mode  7 */
  0.8,      /* mode  8 */
  0.9,      /* mode  9 */
  1.0,      /* mode 10 */
  1./6.,    /* mode 11 */
  1./3.,    /* mode 12 */
  2./3.,    /* mode 13 */
  5./6.     /* mode 14 */

};

/*---------------------------------------------------------------------------*/
/* GAIN QUANTIZATION                                                         */
/*---------------------------------------------------------------------------*/
int    ntt_GAIN_BITS_SCL[LX], ntt_NUM_STEP_SCL[LX];
double ntt_AMP_MAX_SCL[LX], ntt_MU_SCL[LX], ntt_STEP_SCL[LX];
int    ntt_SUB_GAIN_BITS_SCL[LX], ntt_SUB_NUM_STEP_SCL[LX];
double ntt_SUB_AMP_MAX_SCL[LX], ntt_SUB_STEP_SCL[LX];

/*---------------------------------------------------------------------------*/
/* LSP QUANTIZATION                                                          */
/*---------------------------------------------------------------------------*/

int   ntt_N_PR_SCL[LX];         /* LPC order */
double ntt_BAND_EXP_SCL[LX];    /* band expansion factor for LPC analysis */
int   ntt_LSP_BIT0_SCL[LX];     /* number of bits for predictor */
int   ntt_LSP_BIT1_SCL[LX];     /* number of bits for 1st stage VQ */
int   ntt_LSP_BIT2_SCL[LX];     /* number of bits for 2nd stage VQ */
int   ntt_LSP_SPLIT_SCL[LX];    /* number of splits for 2nd stage VQ */
int   ntt_N_MODE_SCL[LX], ntt_NC0_SCL[LX], ntt_NC1_SCL[LX];
char  *ntt_LSPCODEBOOK_SCL[LX]; /* codebook name for LSP quantizaiton */
int   ntt_lsp_csize_scl[LX][ntt_LSP_NSTAGE]; /* codebook size */
int   ntt_lsp_cdim_scl[LX][ntt_LSP_NSTAGE];  /* codebook dimension */

/* VQ codebooks */
double *lsp_code_scl[LX];
double *lsp_fgcode_scl[LX];

/*---------------------------------------------------------------------------*/
/* FORWARD ENVELOPE QUANTIZATION                                             */
/*---------------------------------------------------------------------------*/
/* codebook names */
char *ntt_FW_CB_NAME_SCL[LX];
char *ntt_FW_CB_NAME_S_SCL[LX];
char *ntt_FW_CB_NAME_M_SCL[LX];
/* codebook setting paramters */
int  ntt_FW_N_DIV_SCL[LX];     /* number of interleave division */
int  ntt_FW_N_DIV_S_SCL[LX];
int  ntt_FW_N_DIV_M_SCL[LX];
int  ntt_FW_N_BIT_SCL[LX];     /* number of VQ bits */
int  ntt_FW_N_BIT_S_SCL[LX];
int  ntt_FW_N_BIT_M_SCL[LX];
int  ntt_FW_CB_SIZE_SCL[LX];   /* codebook size */
int  ntt_FW_CB_SIZE_M_SCL[LX];
int  ntt_FW_CB_SIZE_S_SCL[LX];
int  ntt_FW_CB_LEN_SCL[LX];    /* codebook length */
int  ntt_FW_CB_LEN_M_SCL[LX];
int  ntt_FW_CB_LEN_S_SCL[LX];
/* Bark-scale tables */
int  ntt_N_CRB_SCL[LX];      /* table sizes */
int  ntt_N_CRB_S_SCL[LX];
int  ntt_N_CRB_M_SCL[LX];
/*
int  *ntt_crb_tbl_scl[LX];
int  *ntt_crb_tbl_s_scl[LX];
int  *ntt_crb_tbl_m_scl[LX];
*/
int  ntt_crb_tbl_scl[LX][128/*ntt_N_CRB_48_2048*/];   /* tables */
int  ntt_crb_tbl_s_scl[LX][128/*ntt_N_CRB_48_512*/];
int  ntt_crb_tbl_m_scl[LX][128/*ntt_N_CRB_S_48_128*/];

/* VQ codebooks */
double	*ntt_fwcodev_scl[LX];
double	*ntt_fwcodevs_scl[LX];
double	*ntt_fwcodevm_scl[LX];

/*---------------------------------------------------------------------------*/
/* BITRATE CONTROL                                                           */
/*---------------------------------------------------------------------------*/
int ntt_NBITS_FR_SCL[LX];       /* number of available bits per frame */
int ntt_NMTOOL_BITS_SCL[LX];    /* bits for normalization tools */
int ntt_NMTOOL_BITS_M_SCL[LX];
int ntt_NMTOOL_BITS_S_SCL[LX];
int ntt_VQTOOL_BITS_SCL[LX];    /* bits for shape VQ tools */
int ntt_VQTOOL_BITS_M_SCL[LX];
int ntt_VQTOOL_BITS_S_SCL[LX];

int ntt_TBITS_FR_SCL;   /* total bits for scalable coders */

/*---------------------------------------------------------------------------*/
/* RESIDUAL SIGNAL QUANTIZATION                                              */
/*---------------------------------------------------------------------------*/
/* codebook names */
char *ntt_CB_NAME_SCL0[LX], *ntt_CB_NAME_SCL1[LX];
char *ntt_CB_NAME_SCL0m[LX], *ntt_CB_NAME_SCL1m[LX];
char *ntt_CB_NAME_SCL0s[LX], *ntt_CB_NAME_SCL1s[LX];
/* number of pre-selection candidates */
int  ntt_N_CAN_SCL[LX], ntt_N_CAN_S_SCL[LX], ntt_N_CAN_M_SCL[LX];
/* codebook length */
int  ntt_CB_LEN_READ_SCL[LX];
int  ntt_CB_LEN_READ_M_SCL[LX];
int  ntt_CB_LEN_READ_S_SCL[LX];
/* codebooks */
double	*ntt_codev0_scl[LX];
double	*ntt_codev1_scl[LX];
double	*ntt_codev0s_scl[LX];
double	*ntt_codev1s_scl[LX];
double	*ntt_codev0m_scl[LX];
double	*ntt_codev1m_scl[LX];

/*<<>><<>><<>><<>><<>><<>><<>><<>><<>><<>><<>><<>><<>><<>><<>><<>><<>><<>><<*/

#else

/*---------------------------------------------------------------------------*/
/* PROGRAM MODE                                                              */
/*---------------------------------------------------------------------------*/

extern double ntt_AC_TOP[LX][ntt_N_SUP_MAX][4];
extern double ntt_AC_BTM[LX][ntt_N_SUP_MAX][4];

extern int    ntt_NSclLay;         /* number of scale layers */

extern int    ntt_IBPS_SCL[LX];    /* ID number of bitrate  */
extern double ntt_BPS_SCL[LX];     /* bitrate */

extern double ntt_BAND_UPPER_SCL[LX], ntt_BAND_LOWER_SCL[LX]; /* band limit */
/* bandwidth ID */
extern int    ntt_BAND_UPPER_ID_SCL[LX], ntt_BAND_LOWER_ID_SCL[LX];

/* band limit mode table */
extern double b_lim_tbl[];

/*---------------------------------------------------------------------------*/
/* GAIN QUANTIZATION                                                         */
/*---------------------------------------------------------------------------*/
extern int    ntt_GAIN_BITS_SCL[LX], ntt_NUM_STEP_SCL[LX];
extern double ntt_AMP_MAX_SCL[LX], ntt_MU_SCL[LX], ntt_STEP_SCL[LX];
extern int    ntt_SUB_GAIN_BITS_SCL[LX], ntt_SUB_NUM_STEP_SCL[LX];
extern double ntt_SUB_AMP_MAX_SCL[LX], ntt_SUB_STEP_SCL[LX];

/*---------------------------------------------------------------------------*/
/* LSP QUANTIZATION                                                          */
/*---------------------------------------------------------------------------*/

extern int   ntt_N_PR_SCL[LX];         /* LPC order */
extern double ntt_BAND_EXP_SCL[LX];    /* band exp. factor for LPC analysis */
extern int   ntt_LSP_BIT0_SCL[LX];     /* number of bits for predictor */
extern int   ntt_LSP_BIT1_SCL[LX];     /* number of bits for 1st stage VQ */
extern int   ntt_LSP_BIT2_SCL[LX];     /* number of bits for 2nd stage VQ */
extern int   ntt_LSP_SPLIT_SCL[LX];    /* number of splits for 2nd stage VQ */
extern int   ntt_N_MODE_SCL[LX], ntt_NC0_SCL[LX], ntt_NC1_SCL[LX];
extern char  *ntt_LSPCODEBOOK_SCL[LX]; /* codebook name for LSP quantizaiton */
extern int   ntt_lsp_csize_scl[LX][ntt_LSP_NSTAGE]; /* codebook size */
extern int   ntt_lsp_cdim_scl[LX][ntt_LSP_NSTAGE];  /* codebook dimension */

/* VQ codebooks */
extern double *lsp_code_scl[LX];
extern double *lsp_fgcode_scl[LX];

/*---------------------------------------------------------------------------*/
/* FORWARD ENVELOPE QUANTIZATION                                             */
/*---------------------------------------------------------------------------*/
/* codebook names */
extern char *ntt_FW_CB_NAME_SCL[LX];
extern char *ntt_FW_CB_NAME_S_SCL[LX];
extern char *ntt_FW_CB_NAME_M_SCL[LX];
/* codebook setting paramters */
extern int  ntt_FW_N_DIV_SCL[LX];     /* number of interleave division */
extern int  ntt_FW_N_DIV_S_SCL[LX];
extern int  ntt_FW_N_DIV_M_SCL[LX];
extern int  ntt_FW_N_BIT_SCL[LX];     /* number of VQ bits */
extern int  ntt_FW_N_BIT_S_SCL[LX];
extern int  ntt_FW_N_BIT_M_SCL[LX];
extern int  ntt_FW_CB_SIZE_SCL[LX];   /* codebook size */
extern int  ntt_FW_CB_SIZE_M_SCL[LX];
extern int  ntt_FW_CB_SIZE_S_SCL[LX];
extern int  ntt_FW_CB_LEN_SCL[LX];    /* codebook length */
extern int  ntt_FW_CB_LEN_M_SCL[LX];
extern int  ntt_FW_CB_LEN_S_SCL[LX];
/* Bark-scale tables */
extern int  ntt_N_CRB_SCL[LX];      /* table sizes */
extern int  ntt_N_CRB_S_SCL[LX];
extern int  ntt_N_CRB_M_SCL[LX];
/*
extern int  *ntt_crb_tbl_scl[LX];
extern int  *ntt_crb_tbl_s_scl[LX];
extern int  *ntt_crb_tbl_m_scl[LX];
*/
extern int  ntt_crb_tbl_scl[LX][128/*ntt_N_CRB_48_2048*/];   /* tables */
extern int  ntt_crb_tbl_s_scl[LX][128/*ntt_N_CRB_48_512*/];
extern int  ntt_crb_tbl_m_scl[LX][128/*ntt_N_CRB_S_48_128*/];

/* VQ codebooks */
extern double *ntt_fwcodev_scl[LX];
extern double *ntt_fwcodevs_scl[LX];
extern double *ntt_fwcodevm_scl[LX];

/*---------------------------------------------------------------------------*/
/* BITRATE CONTROL                                                           */
/*---------------------------------------------------------------------------*/
extern int ntt_NBITS_FR_SCL[LX];       /* number of available bits per frame */
extern int ntt_NMTOOL_BITS_SCL[LX];    /* bits for normalization tools */
extern int ntt_NMTOOL_BITS_M_SCL[LX];
extern int ntt_NMTOOL_BITS_S_SCL[LX];
extern int ntt_VQTOOL_BITS_SCL[LX];    /* bits for shape VQ tools */
extern int ntt_VQTOOL_BITS_M_SCL[LX];
extern int ntt_VQTOOL_BITS_S_SCL[LX];

extern int ntt_TBITS_FR_SCL;   /* total bits for scalable coders */

/*---------------------------------------------------------------------------*/
/* RESIDUAL SIGNAL QUANTIZATION                                              */
/*---------------------------------------------------------------------------*/
/* codebook names */
extern char *ntt_CB_NAME_SCL0[LX], *ntt_CB_NAME_SCL1[LX];
extern char *ntt_CB_NAME_SCL0m[LX], *ntt_CB_NAME_SCL1m[LX];
extern char *ntt_CB_NAME_SCL0s[LX], *ntt_CB_NAME_SCL1s[LX];
/* number of pre-selection candidates */
extern int  ntt_N_CAN_SCL[LX], ntt_N_CAN_S_SCL[LX], ntt_N_CAN_M_SCL[LX];
/* codebook length */
extern int  ntt_CB_LEN_READ_SCL[LX];
extern int  ntt_CB_LEN_READ_M_SCL[LX];
extern int  ntt_CB_LEN_READ_S_SCL[LX];
/* codebooks */
extern double	*ntt_codev0_scl[LX];
extern double	*ntt_codev1_scl[LX];
extern double	*ntt_codev0s_scl[LX];
extern double	*ntt_codev1s_scl[LX];
extern double	*ntt_codev0m_scl[LX];
extern double	*ntt_codev1m_scl[LX];
/*<<>><<>><<>><<>><<>><<>><<>><<>><<>><<>><<>><<>><<>><<>><<>><<>><<>><<>><<*/

#endif

/*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*/
/**********************  BARK-SCALE BAND TABLES  *****************************/
/*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*/

#ifdef ntt_MAIN_ROUTINE
int ntt_crb_tbl_48_2048_2nd[] = {
     3,
     5,
     8,
    11,
    14,
    16,
    19,
    22,
    25,
    28,
    31,
    34,
    37,
    40,
    43,
    46,
    49,
    52,
    56,
    59,
    62,
    66,
    70,
    73,
    77,
    81,
    85,
    90,
    94,
    99,
   104,
   108,
   114,
   119,
   125,
   131,
   137,
   143,
   150,
   158,
   165,
   174,
   182,
   191,
   201,
   212,
   223,
   235,
   248,
   262,
   278,
   294,
   312,
   332,
   353,
   376,
   402,
   430,
   462,
   496,
   535,
   578,
   627,
   683};
#else
extern int ntt_crb_tbl_48_2048_2nd[];
#endif
#define ntt_N_CRB_48_2048_2nd 64

#ifdef ntt_MAIN_ROUTINE
int ntt_crb_tbl_24_1024_2nd[] = {
     3,
     5,
     8,
    11,
    14,
    16,
    19,
    22,
    25,
    28,
    31,
    34,
    37,
    40,
    43,
    46,
    49,
    52,
    56,
    59,
    62,
    66,
    70,
    73,
    77,
    81,
    85,
    90,
    94,
    99,
   104,
   108,
   114,
   119,
   125,
   131,
   137,
   143,
   150,
   158,
   165,
   174,
   182,
   191,
   201,
   212,
   223,
   235,
   248,
   262,
   278,
   294,
   312,
   332,
   353,
   376,
   402,
   430,
   462,
   496,
   535,
   578,
   627,
   683};
#else
extern int ntt_crb_tbl_24_1024_2nd[];
#endif
#define ntt_N_CRB_24_1024_2nd 64


#ifdef ntt_MAIN_ROUTINE
int ntt_crb_tbl_24_960_2nd[] = {
     3,
     5,
     8,
    10,
    13,
    15,
    18,
    21,
    23,
    26,
    29,
    32,
    35,
    38,
    40,
    43,
    46,
    49,
    53,
    56,
    59,
    62,
    66,
    72,
    77,
    76,
    80,
    85,
    88,
    93,
    98,
   101,
   107,
   112,
   117,
   123,
   129,
   134,
   142,
   148,
   155,
   164,
   171,
   179,
   189,
   199,
   209,
   221,
   233,
   246,
   261,
   276,
   293,
   312,
   331,
   353,
   377,
   404,
   434,
   465,
   502,
   542,
   589,
   640};
#else
extern int ntt_crb_tbl_24_960_2nd[];
#endif
#define ntt_N_CRB_24_960_2nd 64



#ifdef ntt_MAIN_ROUTINE
int ntt_crb_tbl_48_512_2nd[] = {
     1,
     3,
     4,
     5,
     7,
     8,
    10,
    11,
    13,
    15,
    16,
    18,
    20,
    22,
    25,
    27,
    30,
    33,
    36,
    39,
    43,
    48,
    53,
    59,
    65,
    73,
    83,
    94,
   107,
   124,
   144,
   171};
#else
extern int ntt_crb_tbl_48_512_2nd[];
#endif
#define ntt_N_CRB_48_512_2nd 32

#ifdef ntt_MAIN_ROUTINE
int ntt_crb_tbl_24_256_2nd[] = {
     1,
     3,
     4,
     5,
     7,
     8,
    10,
    11,
    13,
    15,
    16,
    18,
    20,
    22,
    25,
    27,
    30,
    33,
    36,
    39,
    43,
    48,
    53,
    59,
    65,
    73,
    83,
    94,
   107,
   124,
   144,
   171};
#else
extern int ntt_crb_tbl_24_256_2nd[];
#endif
#define ntt_N_CRB_24_256_2nd 32


#ifdef ntt_MAIN_ROUTINE
int ntt_crb_tbl_s_48_128_2nd[] = {
     1,
     2,
     3,
     4,
     5,
     7,
     9,
    11,
    15,
    20,
    28,
    43};
#else
extern int ntt_crb_tbl_s_48_128_2nd[];
#endif
#define ntt_N_CRB_S_48_128_2nd 12

#ifdef ntt_MAIN_ROUTINE
int ntt_crb_tbl_s_24_64_2nd[] = {
     1,
     2,
     3,
     4,
     5,
     7,
     9,
    11,
    15,
    20,
    28,
    43};
#else
extern int ntt_crb_tbl_s_24_64_2nd[];
#endif
#define ntt_N_CRB_S_24_64_2nd 12


#ifdef ntt_MAIN_ROUTINE
int ntt_crb_tbl_48_2048_3rd[] = {
346,
350,
355,
360,
364,
370,
375,
381,
385,
391,
397,
402,
408,
414,
420,
426,
433,
439,
446,
453,
460,
466,
474,
481,
489,
497,
504,
513,
521,
529,
537,
546,
556,
566,
576,
586,
596,
606,
617,
629,
640,
651,
663,
674,
686,
698,
713,
727,
742,
757,
771,
787,
803,
820,
838,
855,
872,
901,
911,
932,
955,
976,
998,
1024};
#else
extern int ntt_crb_tbl_48_2048_3rd[];
#endif
#define ntt_N_CRB_48_2048_3rd 64

#ifdef ntt_MAIN_ROUTINE
int ntt_crb_tbl_24_1024_3rd[] = {
346,
350,
355,
360,
364,
370,
375,
381,
385,
391,
397,
402,
408,
414,
420,
426,
433,
439,
446,
453,
460,
466,
474,
481,
489,
497,
504,
513,
521,
529,
537,
546,
556,
566,
576,
586,
596,
606,
617,
629,
640,
651,
663,
674,
686,
698,
713,
727,
742,
757,
771,
787,
803,
820,
838,
855,
872,
901,
911,
932,
955,
976,
998,
1024};
#else
extern int ntt_crb_tbl_24_1024_3rd[];
#endif
#define ntt_N_CRB_24_1024_3rd 64


#ifdef ntt_MAIN_ROUTINE
int ntt_crb_tbl_24_960_3rd[] = {
324,
328,
333,
337,
341,
347,
352,
357,
361,
367,
372,
377,
383,
388,
394,
399,
406,
412,
418,
423,
431,
437,
444,
451,
458,
466,
473,
481,
488,
496,
503,
512,
521,
531,
540,
549,
558,
568,
578,
590,
600,
610,
622,
632,
643,
650,
668,
682,
696,
710,
723,
738,
753,
769,
786,
802,
818,
845,
855,
874,
895,
915,
936,
960};
#else
extern int ntt_crb_tbl_24_960_3rd[];
#endif
#define ntt_N_CRB_24_960_3rd 64


#ifdef ntt_MAIN_ROUTINE
int ntt_crb_tbl_48_512_3rd[] = {
91,
96,
101,
107,
113,
121,
128,
137,
144,
156,
164,
179,
192,
209,
230,
256};
#else
extern int ntt_crb_tbl_48_512_3rd[];
#endif
#define ntt_N_CRB_48_512_3rd 16

#ifdef ntt_MAIN_ROUTINE
int ntt_crb_tbl_24_256_3rd[] = {
91,
96,
101,
107,
113,
121,
128,
137,
144,
156,
164,
179,
192,
209,
230,
256};
#else
extern int ntt_crb_tbl_24_256_3rd[];
#endif
#define ntt_N_CRB_24_256_3rd 16


#ifdef ntt_MAIN_ROUTINE
int ntt_crb_tbl_s_48_128_3rd[] = {
23,
25,
27,
29,
31,
34,
37,
41,
45,
49,
55,
64};
#else
extern int ntt_crb_tbl_s_48_128_3rd[];
#endif
#define ntt_N_CRB_S_48_128_3rd 12

#ifdef ntt_MAIN_ROUTINE
int ntt_crb_tbl_s_24_64_3rd[] = {
23,
25,
27,
29,
31,
34,
37,
41,
45,
49,
55,
64};
#else
extern int ntt_crb_tbl_s_24_64_3rd[];
#endif
#define ntt_N_CRB_S_24_64_3rd 12










