/**********************************************************************
MPEG-4 Audio VM



This software module was originally developed by



and edited by


in the course of development of the MPEG-2 NBC/MPEG-4 Audio standard
ISO/IEC 13818-7, 14496-1,2 and 3. This software module is an
implementation of a part of one or more MPEG-2 NBC/MPEG-4 Audio tools
as specified by the MPEG-2 NBC/MPEG-4 Audio standard. ISO/IEC gives
users of the MPEG-2 NBC/MPEG-4 Audio standards free license to this
software module or modifications thereof for use in hardware or
software products claiming conformance to the MPEG-2 NBC/ MPEG-4 Audio
standards. Those intending to use this software module in hardware or
software products are advised that this use may infringe existing
patents. The original developer of this software module and his/her
company, the subsequent editors and their companies, and ISO/IEC have
no liability for use of this software module or modifications thereof
in an implementation. Copyright is not released for non MPEG-2
NBC/MPEG-4 Audio conforming products. The original developer retains
full right to use the code for his/her own purpose, assign or donate
the code to a third party and to inhibit third party from using the
code for non MPEG-2 NBC/MPEG-4 Audio conforming products. This
copyright notice must be included in all copies or derivative works.

Copyright (c) 1997.

*/
#include "huffdec3.h"
#include "all.h"
#include "port.h"
#include "tf_main.h"

void huffbookinit(int  block_size_samples)
{
    int i;

    hufftab(&book[1],       book1,   4, 1,  HUF1SGN,  11);
    hufftab(&book[2],       book2,   4, 1,  HUF2SGN,  9);
    hufftab(&book[3],       book3,   4, 2,  HUF3SGN,  16+4);
    hufftab(&book[4],       book4,   4, 2,  HUF4SGN,  12+4);
    hufftab(&book[5],       book5,   2, 4,  HUF5SGN,  13);
    hufftab(&book[6],       book6,   2, 4,  HUF6SGN,  11);
    hufftab(&book[7],       book7,   2, 7,  HUF7SGN,  12+2);
    hufftab(&book[8],       book8,   2, 7,  HUF8SGN,  10+2);
    hufftab(&book[9],       book9,   2, 12, HUF9SGN,  15+2);
    hufftab(&book[10],      book10,  2, 12, HUF10SGN, 12+2);
    hufftab(&book[11],      book11,  2, 16, HUF11SGN, 5+2+2*21);

    hufftab(&book[BOOKSCL], bookscl, 1, 60, 1,        19);

    for(i = 0; i < TEXP; i++){
	exptable[i]  = pow( 2.0,  0.25*i);
    }
    maxfac = TEXP;

    for(i = 0; i < MAX_IQ_TBL; i++){
	iq_exp_tbl[i] = pow(i, 4./3.);
    }

    infoinit(&samp_rate_info[mc_info.sampling_rate_idx], block_size_samples);
}

void
infoinit(SR_Info *sip, int block_size_samples )
{ 
    int i, j, k, n, ws;
    short *sfbands;
    Info *ip;

    /* long block info */
    ip = &only_long_info;
    win_seq_info[ONLY_LONG_WINDOW] = ip;
    ip->islong = 1;
    ip->nsbk = 1;
    ip->bins_per_bk =  block_size_samples ;
    ip->longFssGroups = sip->longFssGroups;
    for (i=0; i<ip->nsbk; i++) {
	ip->sectbits[i] = LONG_SECT_BITS;
	if (block_size_samples==960) {
	  ip->sbk_sfb_top[i] = sip->SFbands960;
	  ip->sfb_per_sbk[i] = sip->nsfb960;
	}
	if (block_size_samples==1024) {
		ip->sfb_per_sbk[i] = sip->nsfb1024;
		ip->sbk_sfb_top[i] = sip->SFbands1024;
	}
    }
    ip->sfb_width_short = NULL;
    ip->num_groups = 1;
    ip->group_len[0] = 1;
    ip->group_offs[0] = 0;
    
    /* short block info */
    ip = &eight_short_info;
    win_seq_info[EIGHT_SHORT_WINDOW] = ip;
    ip->islong = 0;
    ip->nsbk = NSHORT;
    ip->bins_per_bk = block_size_samples;
    ip->shortFssWidth = sip->shortFssWidth;
    for (i=0; i<ip->nsbk; i++) {
	ip->sectbits[i] = SHORT_SECT_BITS;
	if (block_size_samples==960) {
	  ip->sbk_sfb_top[i] = sip->SFbands120;
	  ip->sfb_per_sbk[i] = sip->nsfb120;
	}
	if (block_size_samples==1024) {
	  ip->sbk_sfb_top[i] = sip->SFbands128;
	  ip->sfb_per_sbk[i] = sip->nsfb128;
	}
    }
    /* construct sfb width table */
    ip->sfb_width_short = sfbwidthShort;
    for (i=0, j=0, n=ip->sfb_per_sbk[0]; i<n; i++) {
	k = ip->sbk_sfb_top[0][i];
	ip->sfb_width_short[i] = k - j;
	j = k;
    }
    
    /* common to long and short */
    for (ws=0; ws<NUM_WIN_SEQ; ws++) {
        if ((ip = win_seq_info[ws]) == NULL)
            continue;
	ip->sfb_per_bk = 0;   
	k = 0;
	n = 0;
        for (i=0; i<ip->nsbk; i++) {
            /* compute bins_per_sbk */
	    ip->bins_per_sbk[i] = ip->bins_per_bk / ip->nsbk;
	    
            /* compute sfb_per_bk */
            ip->sfb_per_bk += ip->sfb_per_sbk[i];

            /* construct default (non-interleaved) bk_sfb_top[] */
            sfbands = ip->sbk_sfb_top[i];
            for (j=0; j < ip->sfb_per_sbk[i]; j++)
                ip->bk_sfb_top[j+k] = sfbands[j] + n;

            n += ip->bins_per_sbk[i];
            k += ip->sfb_per_sbk[i];
	}	    
 
	if (debug['I']) {
	    PRINT(SE,"\nsampling rate %d\n", sip->samp_rate);
	    PRINT(SE,"win_info\t%d has %d windows\n", ws, ip->nsbk);
	    PRINT(SE,"\tbins_per_bk\t%d\n", ip->bins_per_bk);
	    PRINT(SE,"\tsfb_per_bk\t%d\n", ip->sfb_per_bk);
	    for (i=0; i<ip->nsbk; i++) {
		PRINT(SE,"window\t%d\n", i);
		PRINT(SE,"\tbins_per_sbk\t%d\n", ip->bins_per_sbk[i]);
		PRINT(SE,"\tsfb_per_sbk	%d\n", ip->sfb_per_sbk[i]);
	    }
	    if (ip->sfb_width_short != NULL) {
		PRINT(SE,"sfb top and width\n");
		for (i=0; i<ip->sfb_per_sbk[0]; i++)
		    PRINT(SE,"%6d %6d %6d\n", i, 
			ip->sbk_sfb_top[0][i], 
			ip->sfb_width_short[i]);
	    }	   
	}	 
    }	    
}
