/*****************************************************************************
 *                                                                           *
"This software module was originally developed by 

Ralph Sperschneider (Fraunhofer Gesellschaft IIS)

in the course of development of the MPEG-2 NBC/MPEG-4 Audio standard ISO/IEC 13818-7, 
14496-1,2 and 3. This software module is an implementation of a part of one or more 
MPEG-2 NBC/MPEG-4 Audio tools as specified by the MPEG-2 NBC/MPEG-4 
Audio standard. ISO/IEC  gives users of the MPEG-2 NBC/MPEG-4 Audio 
standards free license to this software module or modifications thereof for use in 
hardware or software products claiming conformance to the MPEG-2 NBC/MPEG-4
Audio  standards. Those intending to use this software module in hardware or 
software products are advised that this use may infringe existing patents. 
The original developer of this software module and his/her company, the subsequent 
editors and their companies, and ISO/IEC have no liability for use of this software 
module or modifications thereof in an implementation. Copyright is not released for 
non MPEG-2 NBC/MPEG-4 Audio conforming products.The original developer
retains full right to use the code for his/her  own purpose, assign or donate the 
code to a third party and to inhibit third party from using the code for non 
MPEG-2 NBC/MPEG-4 Audio conforming products. This copyright notice must
be included in all copies or derivative works." 
Copyright(c)1996.
 *                                                                           *
 ****************************************************************************/
#ifndef _HUFFDEC2_H_
#define _HUFFDEC2_H_

#ifdef VERSION2
#define UNIT_INTERLEAVING  1
#endif /*VERSION2*/

#include "tf_main.h"
#include "all.h"
#include "nok_lt_prediction.h"
#include "resilience.h"
#include "reorderspec.h"

void          clr_tns ( Info*           info, 
                        TNS_frame_info* tns_frame_info );

void          getgroup ( Info*             info, 
                         byte*             group,
                         HANDLE_RESILIENCE hResilience,
                         HANDLE_BUFFER     hVm, 
                         HANDLE_EP_INFO    hEPInfo  );

int           getics ( Info*                    info, 
                       int                      common_window, 
                       WINDOW_TYPE*             win, 
                       Window_shape*            wshape, 
                       byte*                    group, 
                       byte*                    max_sfb, 
                       PRED_TYPE                pred_type, 
                       int*                     lpflag, 
                       int*                     prstflag,  
                       byte*                    cb_map, 
                       Float*                   coef, 
                       short*                   global_gain, 
                       short*                   factors,
                       NOK_LT_PRED_STATUS*      nok_ltp, 
                       TNS_frame_info*          tns,
                       BsBitStream *            ,
                       enum AAC_BIT_STREAM_TYPE bitStreamType,
                       HANDLE_RESILIENCE        hResilience,
                       HANDLE_BUFFER            hVm,
                       HANDLE_BUFFER            hHcrSpecData,
                       HANDLE_HCR               hHcrInfo, HANDLE_EP_INFO hEPInfo   );

int           getmask ( Info*             info, 
                        byte*             group, 
                        byte              max_sfb, 
                        byte*             mask,
                        HANDLE_RESILIENCE hResilience,
                        HANDLE_BUFFER     hVm, 
                        HANDLE_EP_INFO    hEPInfo  );

unsigned char HuffSpecKernelPure ( int*           qp, 
                                   Hcb*           hcb, 
                                   Huffman*       hcw, 
                                   int            step,
                                   unsigned short table,
                                   HANDLE_BUFFER  hVm,
                                   HANDLE_RESILIENCE  hResilinece, HANDLE_EP_INFO hEPInfo  );

void          ResetReadBitCnt ( HANDLE_BUFFER hVm );

#endif  /* #ifndef _HUFFDEC2_H_ */
