/************************* MPEG-2 NBC Audio Decoder **************************
 *                                                                           *
"This software module was originally developed by 
AT&T, Dolby Laboratories, Fraunhofer Gesellschaft IIS and edited by
Yoshiaki Oikawa (Sony Corporation),
Mitsuyuki Hatanaka (Sony Corporation)
in the course of development of the MPEG-2 NBC/MPEG-4 Audio standard ISO/IEC 13818-7, 
14496-1,2 and 3. This software module is an implementation of a part of one or more 
MPEG-2 NBC/MPEG-4 Audio tools as specified by the MPEG-2 NBC/MPEG-4 
Audio standard. ISO/IEC  gives users of the MPEG-2 NBC/MPEG-4 Audio 
standards free license to this software module or modifications thereof for use in 
hardware or software products claiming conformance to the MPEG-2 NBC/MPEG-4
Audio  standards. Those intending to use this software module in hardware or 
software products are advised that this use may infringe existing patents. 
The original developer of this software module and his/her company, the subsequent 
editors and their companies, and ISO/IEC have no liability for use of this software 
module or modifications thereof in an implementation. Copyright is not released for 
non MPEG-2 NBC/MPEG-4 Audio conforming products.The original developer
retains full right to use the code for his/her  own purpose, assign or donate the 
code to a third party and to inhibit third party from using the code for non 
MPEG-2 NBC/MPEG-4 Audio conforming products. This copyright notice must
be included in all copies or derivative works." 
Copyright(c)1996.
 *                                                                           *
 ****************************************************************************/
#include "all.h"
#include "bitstream.h"
#include "port.h"
#include "concealment.h"

/*
 * read and decode the data for the next 1024 output samples
 * return -1 if there was an error
 */
int huffdecode ( int                      id, 
                 MC_Info*                 mip, 
                 WINDOW_TYPE*             win, 
                 Wnd_Shape*               wshape, 
                 byte**                   cb_map, 
                 short**                  factors, 
                 byte**                   group, 
                 byte*                    hasmask, 
                 byte**                   mask, 
                 byte*                    max_sfb, 
                 PRED_TYPE                pred_type, 
                 int**                    lpflag, 
                 int**                    prstflag,
                 NOK_LT_PRED_STATUS**     nok_ltp_status, 
                 TNS_frame_info**         tns, 
                 BsBitStream*             gc_stream[], 
                 Float**                  coef, 
                 enum AAC_BIT_STREAM_TYPE bitStreamType,
                 int                      common_window,
                 Info*                    sfbInfo,
                 HANDLE_RESILIENCE        hResilience,
                 HANDLE_BUFFER            hVm,
                 HANDLE_BUFFER            hHcrSpecData,
                 HANDLE_HCR               hHcrInfo,
                 HANDLE_EP_INFO           hEPInfo )
{
  int i, tag, ch, widx, first=0, last=0;

  short global_gain;  /* not used in this routine */
  if (bitStreamType != SCALEABLE) {
    tag = GetBits ( ELEMENT_INSTANCE_TAG, 
                    LEN_TAG,
                    hResilience,
                    hVm, 
                    hEPInfo );   
  }  else {
    tag=0;
  }
   


  switch(id) {
  case ID_SCE:
  case ID_LFE:
    common_window = 0;
    break;
  case ID_CPE:
    if (bitStreamType != SCALEABLE) {
      common_window = GetBits ( COMMON_WINDOW, 
                                LEN_COM_WIN,
                                hResilience,
                                hVm, 
                                hEPInfo );
    }
    break;
  default:
    PRINT(SE,"Unknown id %d\n", id);
    return(-1);
  }
  
  if ((ch = chn_config(id, tag, common_window, mip)) < 0)
    return -1;
  
  switch(id) {
  case ID_SCE:
  case ID_LFE:
    widx = mip->ch_info[ch].widx;
    first = ch;
    last = ch;
    hasmask[widx] = 0;
    break;
  case ID_CPE:
    first = ch;
    last = mip->ch_info[ch].paired_ch;
    if ( (common_window) && ( bitStreamType != SCALEABLE )) {
      widx = mip->ch_info[ch].widx;
      get_ics_info ( &win[widx], 
                     &wshape[widx].this_bk, 
                     group[widx],
                     &max_sfb[widx], 
                     pred_type, 
                     lpflag[widx], 
                     prstflag[widx], 
                     bitStreamType,
                     hResilience,
                     hVm, 
                     hEPInfo);
      hasmask[widx] = getmask ( winmap[win[widx]], 
                                group[widx], 
                                max_sfb[widx], 
                                mask[widx],
                                hResilience,
                                hVm, 
                                hEPInfo );
    }
    else { 
      hasmask[mip->ch_info[first].widx] = 0;
      hasmask[mip->ch_info[last].widx] = 0;
    }
    break;
  }
  
  if(debug['v']) {
    PRINT(SE,"tag %d, common window %d\n", tag, common_window);
    PRINT(SE,"nch %d, channels %d %d, widx %d %d\n",
          last-first+1, first, last, 
          mip->ch_info[first].widx, mip->ch_info[last].widx);
  }
  
  for (i=first; i<=last; i++) {
    widx = mip->ch_info[i].widx;

    fltclr(coef[i], LN2);
    ConcealmentSetChannel(i);
    if ( ! getics ( sfbInfo, 
                    common_window, 
                    &win[widx], 
                    &(wshape[widx].this_bk),
                    group[widx], 
                    &max_sfb[widx], 
                    pred_type, 
                    lpflag[widx], 
                    prstflag[widx], 
                    cb_map[i], 
                    coef[i], 
                    &global_gain, 
                    factors[i], 
                    nok_ltp_status[widx], 
                    tns[i],
                    gc_stream[i-first], 
                    bitStreamType,
                    hResilience,
                    hVm,
                    hHcrSpecData,
                    hHcrInfo, hEPInfo ) )
      return -1;
  }
  return 0;
}

void get_ics_info ( WINDOW_TYPE*              win, 
                    Window_shape*             wshape, 
                    byte*                     group,
                    byte*                     max_sfb, 
                    PRED_TYPE                 pred_type, 
                    int*                      lpflag, 
                    int*                      prstflag, 
                    enum  AAC_BIT_STREAM_TYPE bitStreamType,
                    HANDLE_RESILIENCE         hResilience,
                    HANDLE_BUFFER             hVm, 
                    HANDLE_EP_INFO            hEPInfo )
{
  int i, j;
  int max_pred_sfb = pred_max_bands();
  Info *info;
  if (bitStreamType != SCALEABLE) {
    GetBits ( ICS_RESERVED, 
              LEN_ICS_RESERV,
              hResilience,
              hVm, 
              hEPInfo );	    /* reserved bit */
    *win    = (WINDOW_TYPE)  GetBits ( WINDOW_SEQUENCE_CODE, 
                                       LEN_WIN_SEQ,
                                       hResilience,
                                       hVm, 
                                       hEPInfo );
    *wshape = (Window_shape) GetBits ( WINDOW_SHAPE, 
                                       LEN_WIN_SH,
                                       hResilience,
                                       hVm, 
                                       hEPInfo );
  }
  if ((info = winmap[*win]) == NULL)
    CommonExit(1,"bad window code");
  
  /*
   * max scale factor, scale factor grouping and prediction flags
   */
  prstflag[0] = 0;
  if (info->islong) {
    *max_sfb = GetBits ( MAX_SFB, 
                         LEN_MAX_SFBL,
                         hResilience,
                         hVm, 
                         hEPInfo );
    group[0] = 1;
    if ((lpflag[0] = GetBits ( PREDICTOR_DATA_PRESENT, 
                               LEN_PRED_PRES,
                               hResilience,
                               hVm, 
                               hEPInfo ))) {
      if ((prstflag[0] = GetBits ( PREDICTOR_RESET, 
                                   LEN_PRED_RST,
                                   hResilience,
                                   hVm, 
                                   hEPInfo ))) {
	for(i=1; i<LEN_PRED_RSTGRP+1; i++)
	  prstflag[i] = GetBits ( PREDICTOR_RESET_GROUP_NUMBER, 
                                  LEN_PRED_RST,
                                  hResilience,
                                  hVm, 
                                  hEPInfo );
      }
      j = ( (*max_sfb < max_pred_sfb) ? 
            *max_sfb : max_pred_sfb ) + 1;

      if (pred_type == MONOPRED) {
        for (i = 1; i < j; i++)
	  lpflag[i] = GetBits ( PREDICTION_USED, 
                                LEN_PRED_ENAB,
                                hResilience,
                                hVm, 
                                hEPInfo );  
        for ( ; i < max_pred_sfb+1; i++)
          lpflag[i] = 0  /* 1  SRQ FIX!!!! */;
        
      } else if (pred_type == NOK_BWP) {
        for (i = 1; i < j; i++) 
	  lpflag[i] = GetBits ( PREDICTION_USED, 
                                LEN_PRED_ENAB,
                                hResilience,
                                hVm, 
                                hEPInfo );
	for ( ; i < max_pred_sfb+1; i++)
	  lpflag[i] = 0;
      }
    }
  }
  else {
    *max_sfb = GetBits ( MAX_SFB, 
                         LEN_MAX_SFBS,
                         hResilience,
                         hVm, 
                         hEPInfo );
    getgroup ( info, 
               group, 
               hResilience,
               hVm, 
               hEPInfo );
    lpflag[0] = 0;
  }
  
  if(debug['v']) {
    PRINT(SE,"win %d, wsh %d\n", *win, *wshape);
    PRINT(SE,"max_sf %d\n", *max_sfb);
  }
  
  if (debug['p']) {
    if (lpflag[0]) {
      PRINT(SE,"prediction enabled (%2d):  ", *max_sfb);
      for (i=1; i<max_pred_sfb+1; i++)
        PRINT(SE," %d", lpflag[i]);
      PRINT(SE,"\n");
    }
  }
}
