/*****************************************************************************
 *                                                                           *
"This software module was originally developed by 

Ralph Sperschneider (Fraunhofer Gesellschaft IIS)

in the course of development of the MPEG-2 NBC/MPEG-4 Audio standard ISO/IEC 13818-7, 
14496-1,2 and 3. This software module is an implementation of a part of one or more 
MPEG-2 NBC/MPEG-4 Audio tools as specified by the MPEG-2 NBC/MPEG-4 
Audio standard. ISO/IEC  gives users of the MPEG-2 NBC/MPEG-4 Audio 
standards free license to this software module or modifications thereof for use in 
hardware or software products claiming conformance to the MPEG-2 NBC/MPEG-4
Audio  standards. Those intending to use this software module in hardware or 
software products are advised that this use may infringe existing patents. 
The original developer of this software module and his/her company, the subsequent 
editors and their companies, and ISO/IEC have no liability for use of this software 
module or modifications thereof in an implementation. Copyright is not released for 
non MPEG-2 NBC/MPEG-4 Audio conforming products.The original developer
retains full right to use the code for his/her  own purpose, assign or donate the 
code to a third party and to inhibit third party from using the code for non 
MPEG-2 NBC/MPEG-4 Audio conforming products. This copyright notice must
be included in all copies or derivative works." 
Copyright(c)1998.
 *                                                                           *
 ****************************************************************************/
#include "buffers.h"
#include "bitfct.h"
#include "resilience.h"
#include "all.h"
/*******************/
/*** definitions ***/
/*******************/

typedef struct tag_buffer
{
  unsigned char* physBuf;
  unsigned long  readBitCnt;
  unsigned long  readBitCntMemo;
  unsigned long  writeBitCnt;
  unsigned long  writeBitCntMemo;
  BIT_BUF        bitBuf;
  BIT_BUF        bitBufMemo;
} T_BUFFER;


/*****************/
/*** functions ***/
/*****************/

/****************************/
/**** framework handling ****/
static BsBitStream *vmBitBuffer;

void setHuffdec2BitBuffer ( BsBitStream* fixed_stream )
{
  vmBitBuffer = fixed_stream;
} 

/* align byte if necessary */
void byte_align ( void )
{
  int i;
  int curBitPos;

  curBitPos = BsCurrentBit ( vmBitBuffer );
  i = curBitPos % 8;
  if (!i) {
    i = 8-i;
    BsGetSkip( vmBitBuffer, i);
  }
}

HANDLE_BUFFER CreateBuffer ( unsigned long bufferSize )
{
  HANDLE_BUFFER handle;

  handle = (HANDLE_BUFFER) malloc ( sizeof(T_BUFFER) );
  if ( bufferSize )
    handle->physBuf = (unsigned char*) malloc ( sizeof ( char ) * bufferSize );
  else
    handle->physBuf = NULL;
  return ( handle );
}
#ifdef VERSION2
void FinishWriting ( HANDLE_BUFFER handle )
{
  FlushWriteBitBuf ( &(handle->bitBuf) );
}

#endif /* VERSION2 */

long GetBits ( CODE_TABLE        code,    /* NEW ... to decode EP bitstream */
               int               n,
               HANDLE_RESILIENCE hResilience,
               HANDLE_BUFFER     handle,
               HANDLE_EP_INFO    hEPInfo )

{
  unsigned long  value;

    if ( n != 0 )
      {
        handle->readBitCnt += n; 
        if ( handle->physBuf == NULL )
          {
#ifdef VERSION2
            if( GetEPFlag ( hResilience ) ) 
              BsGetBitEP (code, hEPInfo, vmBitBuffer, &value, n );
            else
#endif
              BsGetBit ( vmBitBuffer, &value, n );
            if (debug['b'])
              PRINT(SE, "  AAC: GetBits: val=%5ld      num=%5d\n", value, n );
          }
#ifdef VERSION2
        else
          value = ReadBitBuf ( &(handle->bitBuf), n ); 
#endif /*VERSION2*/
        return ( value );
      }
    else
      return ( 0 );
}

unsigned long GetReadBitCnt ( HANDLE_BUFFER handle )
{
  return ( handle->readBitCnt );
}

#ifdef VERSION2
void PrepareReading ( HANDLE_BUFFER handle )
{
  InitReadBitBuf ( &(handle->bitBuf), handle->physBuf );
}

void PrepareWriting ( HANDLE_BUFFER handle )
{
  InitWriteBitBuf ( &(handle->bitBuf), handle->physBuf );
}

void PutBits ( int               n,
               HANDLE_BUFFER     handle,
               unsigned long     value )
{
  if ( n != 0 ) {
    handle->writeBitCnt += n; 
    if ( handle->physBuf == NULL ) {
      CommonExit( 1, "buffers.c: PutBits()" );
    }
    else {
      WriteBitBuf ( &(handle->bitBuf), value, n );
    }
  }
}
#endif /*VERSION2*/

void ResetReadBitCnt ( HANDLE_BUFFER handle )
{
  handle->readBitCnt = 0;
}

void ResetWriteBitCnt ( HANDLE_BUFFER handle )
{
  handle->writeBitCnt = 0;
}

void RestoreBufferPointer ( HANDLE_BUFFER handle )
{
  handle->readBitCnt  = handle->readBitCntMemo;
  handle->writeBitCnt = handle->writeBitCntMemo;
  handle->bitBuf      = handle->bitBufMemo;
}

void StoreBufferPointer ( HANDLE_BUFFER handle )
{
  handle->readBitCntMemo  = handle->readBitCnt;
  handle->writeBitCntMemo = handle->writeBitCnt;
  handle->bitBufMemo      = handle->bitBuf;
}

#ifdef VERSION2

void TransferBits ( HANDLE_BUFFER     fromHandle,
                    HANDLE_BUFFER     toHandle,
                    unsigned long     nrOfBits,
                    HANDLE_RESILIENCE hResilience,
                    HANDLE_EP_INFO    hEPInfo )
{
  if ( toHandle->physBuf == NULL )
    CommonExit( 1, "buffers.c: Transferbits()" );
  if ( fromHandle->physBuf == NULL )
    {
      unsigned long  lengthOfLong;
      unsigned long  readBitCnt;
      
      lengthOfLong = sizeof ( long ) * 8;
      for ( readBitCnt = 0; ( readBitCnt + lengthOfLong ) <= nrOfBits; readBitCnt += lengthOfLong )
        {
          WriteBitBuf ( &(toHandle->bitBuf),
                        GetBits ( HCOD, 
                                  lengthOfLong, 
                                  hResilience,
                                  fromHandle, 
                                  hEPInfo ),
                        lengthOfLong );
          toHandle->writeBitCnt += lengthOfLong; /* readBitCnt is set by GetBits */
        }
      WriteBitBuf ( &(toHandle->bitBuf),
                    GetBits ( HCOD, 
                              nrOfBits%lengthOfLong, 
                              hResilience,
                              fromHandle, 
                              hEPInfo ),
                    nrOfBits%lengthOfLong );
      toHandle->writeBitCnt += nrOfBits%lengthOfLong; /* readBitCnt is set by GetBits */
    }
  else
    {
      TransferBitsBetweenBitBuf ( &(fromHandle->bitBuf), 
                                  &(toHandle->bitBuf), 
                                  nrOfBits );
      fromHandle->readBitCnt += nrOfBits;
      toHandle->writeBitCnt += nrOfBits;
    }
}

#endif /*VERSION2*/

