/**********************************************************************
MPEG4 Audio VM Module
parameter based codec - HILN: harmonic/individual lines and noise
                              extraction



This software module was originally developed by

Heiko Purnhagen (University of Hannover / Deutsche Telekom Berkom)
Bernd Edler (University of Hannover / Deutsche Telekom Berkom)

and edited by

in the course of development of the MPEG-2 NBC/MPEG-4 Audio standard
ISO/IEC 13818-7, 14496-1,2 and 3. This software module is an
implementation of a part of one or more MPEG-2 NBC/MPEG-4 Audio tools
as specified by the MPEG-2 NBC/MPEG-4 Audio standard. ISO/IEC gives
users of the MPEG-2 NBC/MPEG-4 Audio standards free license to this
software module or modifications thereof for use in hardware or
software products claiming conformance to the MPEG-2 NBC/ MPEG-4 Audio
standards. Those intending to use this software module in hardware or
software products are advised that this use may infringe existing
patents. The original developer of this software module and his/her
company, the subsequent editors and their companies, and ISO/IEC have
no liability for use of this software module or modifications thereof
in an implementation. Copyright is not released for non MPEG-2
NBC/MPEG-4 Audio conforming products. The original developer retains
full right to use the code for his/her own purpose, assign or donate
the code to a third party and to inhibit third party from using the
code for non MPEG-2 NBC/MPEG-4 Audio conforming products. This
copyright notice must be included in all copies or derivative works.

Copyright (c) 1997.



Header file: indilinextr.h

$Id: indilinextr.h,v 1.3 1998/04/10 15:43:56 purnhage Exp $

Required libraries:
libuhd_psy.a		indiline psychoacoustic model

Required modules:
indilinecom.o		indiline common module
uhd_fft.o		FFT and ODFT module

Authors:
HP    Heiko Purnhagen, Uni Hannover <purnhage@tnt.uni-hannover.de>
BE    Bernd Edler, Uni Hannover <edler@tnt.uni-hannover.de>

Changes:
01-sep-96   HP    first version based on indiline.c
10-sep-96   BE
11-sep-96   HP
26-sep-96   HP    new indiline module interfaces
29-nov-96   HP    updated to modular code structure by BE
10-feb-97   HP    updated to modular freq. estim. by BE
27-feb-97   HP    added IndiLineExtractFree()
10-apr-97   HP    harmonic stuff ...
18-apr-97   HP    noisy stuff ...
19-jun-97   HP    improved env/harm/noise interface
16-feb-98   HP    improved noiseFreq
09-apr-98   HP    ILXconfig
**********************************************************************/


#ifndef _indilinextr_h_
#define _indilinextr_h_

#include "indilinecom.h"	/* indiline common module */

/* units & formats: */
/*  Freq: frequency in Hz */
/*  Ampl: peak amplitude of sine wave */
/*  Phase: phase in rad at frame center */
/*  Index: NumBit LSBs, to be transmitted MSB first */
/*  Pred: line predecessor index: 0=no pred., 1=line[0], 2=line[1], ... */


/* ---------- declarations ---------- */

typedef struct ILXstatusStruct ILXstatus;	/* ILX status handle */

typedef struct ILXconfigStruct ILXconfig;	/* ILX configuration */

struct ILXconfigStruct
{
  float dummy1;
  float dummy2;
  int dummy3;
};


/* ---------- functions ---------- */

#ifdef __cplusplus
extern "C" {
#endif


/* IndiLineExtractInit() */
/* Init individual lines extraction. */

ILXstatus *IndiLineExtractInit (
  int frameLen,			/* in: samples per frame */
  float fSample,		/* in: sampling frequency */
  float maxLineFreq,		/* in: max line frequency */
  float maxLineAmpl,		/* in: max line amplitude */
  int maxNumLine,		/* in: max num lines */
  int maxNumEnv,		/* in: max num envelopes */
  int maxNumHarm,		/* in: max num harmonic tones */
  int maxNumHarmLine,		/* in: max num lines of harmonic tone */
  int maxNumNoisePara,		/* in: max num noise parameters */
  float maxNoiseFreq,		/* in: max noise frequency */
  ILXconfig *cfg,		/* in: ILX configuration */
				/*     or NULL */
  int debugLevel);		/* in: debug level (0=off) */
				/* returns: ILX status handle */


/* IndiLineExtract() */
/* Extraction of individual lines and envelope from the current */
/* residual signal. */

void IndiLineExtract (
  ILXstatus *ILX,		/* in: ILX status handle */
  float *residualSignal,	/* in: residual signal */
				/*  [0..2.5*frameLen-1] */
				/*  previous frame, */
				/*  current frame, */
				/*  1st half next frame */
  float *synthSignal,		/* in: synthesised signal */
				/*  [0..2.5*frameLen-1] */
				/*  (currently not used) */
  float *finePitchPeriod,	/* in: (currently not used) */
  float *slowHarm,		/* in: (currently not used) */
  float *LPCcoef,		/* in: (currently not used) */
  int numLine,			/* in: num lines to extract */
				/*     -1 to disable extraction */
  int *numEnv,			/* out: num envelopes */
  float ***envPara,		/* out: envelope parameters */
				/*      [0..numEnv-1][0..ENVPARANUM-1] */
  int *numLineExtract,		/* out: num lines extracted */
  float **lineFreq,		/* out: line frequency [Hz] */
				/*      [0..numLine-1] */
  float **lineAmpl,		/* out: line amplitude */
				/*      [0..numLine-1] */
  float **linePhase,		/* out: line phase [rad] */
				/*      [0..numLine-1] */
  int **lineEnv,		/* out: line envelope flag/idx */
				/*      [0..numLine-1] */
  int **linePred,		/* out: line predecessor idx */
				/*      [0..numLine-1] */
  int *numHarm,			/* out: num harmonic tones */
  int **numHarmLine,		/* out: num lines of harmonic tone */
				/*      [0..numHarm-1] */
  float **harmFreq,		/* out: harm fundamental frequency [Hz] */
				/*      [0..numHarm-1] */
  float **harmFreqStretch,	/* out: harm freq stretch ratio */
				/*      [0..numHarm-1] */
  int **harmLineIdx,		/* out: harm line para start idx */
				/*      [0..numHarm-1] */
				/*      ampl: lineAmpl[idx] etc. */
				/*      idx=harmLineIdx+(0..numHarmLine-1) */
  int **harmEnv,		/* out: harm envelope flag/idx */
				/*      [0..numHarm-1] */
  int **harmPred,		/* out: harm tone predecessor idx */
				/*      [0..numHarm-1] */
  float **harmRate,		/* out: bitrate for harm data (0..1) */
				/*      [0..numHarm-1] */
  int *numNoisePara,		/* out: num noise parameter */
  float *noiseFreq,		/* out: max noise freq (bandwidth) [Hz] */
  float **noisePara,		/* out: noise parameter (DCT) */
				/*      [0..numNoisePara-1] */
  int *noiseEnv,		/* out: noise envelope flag/idx */
  float *noiseRate);		/* out: bitrate for noise data (0..1) */


/* IndiLineExtractFree() */
/* Free memory allocated by IndiLineExtractInit(). */

void IndiLineExtractFree (
  ILXstatus *ILX);		/* in: ILX status handle */


#ifdef __cplusplus
}
#endif

#endif	/* #ifndef _indilinextr_h_ */

/* end of indilinextr.h */
