
/*

This software module was originally developed by

    Masayuki Nishiguchi, Kazuyuki Iijima, and Jun Matsumoto (Sony Corporation)

    and edited by

    Heiko Purnhagen (University of Hannover)

    in the course of development of the MPEG-4 Audio standard (ISO/IEC 14496-3).
    This software module is an implementation of a part of one or more
    MPEG-4 Audio (ISO/IEC 14496-3) tools as specified by the MPEG-4 Audio
    standard (ISO/IEC 14496-3).
    ISO/IEC gives users of the MPEG-4 Audio standards (ISO/IEC 14496-3)
    free license to this software module or modifications thereof for use
    in hardware or software products claiming conformance to the MPEG-4
    Audio standards (ISO/IEC 14496-3).
    Those intending to use this software module in hardware or software
    products are advised that this use may infringe existing patents.
    The original developer of this software module and his/her company,
    the subsequent editors and their companies, and ISO/IEC have no
    liability for use of this software module or modifications thereof in
    an implementation.
    Copyright is not released for non MPEG-4 Audio (ISO/IEC 14496-3)
    conforming products. The original developer retains full right to use
    the code for his/her own purpose, assign or donate the code to a third
    party and to inhibit third party from using the code for non MPEG-4
    Audio (ISO/IEC 14496-3) conforming products.
    This copyright notice must be included in all copies or derivative works.

    Copyright (c)1996.

*/

/**********************************************************************
Dummy version of hvxcDec.c

Authors:
HP    Heiko Purnhagen, Uni Hannover <purnhage@tnt.uni-hannover.de>

Changes:
06-feb-97   HP    born (based on hvxcDec.c)
11-nov-97   HP    updated
**********************************************************************/

#include <math.h>
#include <stdio.h>
#include <signal.h>

#include "common.h"
#include "hvxc.h"
#include "hvxcDec.h"
#include "hvxcCommon.h"
#include "pan_par_const.h"


void IPC_HVXCInitDec(void)
{
  CommonExit(1,"IPC_HVXCInitDec: dummy");
}

int IPC_DecParams1st(
unsigned char	*encBit,
float		pchmod,
int		*idVUV2,
float		(*qLspQueue)[LPCORDER],
float		*pch2,
float		(*am2)[SAMPLE / 2][3],
IdCelp		*idCelp2)
{
  CommonExit(1,"IPC_DecParams1st: dummy");
}

int IPC_DecParams1stVR(
unsigned char   *encBit,
float           pchmod,
int             *idVUV2,
int             *bgnFlag2,
float           (*qLspQueue)[LPCORDER],
float           *pch2,
float           (*am2)[SAMPLE / 2][3],
IdCelp          *idCelp2)
{
  CommonExit(1,"IPC_DecParams1stVR: dummy");
}

void IPC_DecParams2nd(
int	fr0,
int	*idVUV2,
float	(*qLspQueue)[LPCORDER],
IdCelp	*idCelp2,
float	(*qLsp2)[LPCORDER],
float	(*qRes2)[FRM])
{
  CommonExit(1,"IPC_DecParams2nd: dummy");
}

void IPC_DecParams2ndVR(
int     fr0,
int     *idVUV2,
int     *bgnFlag2,
float   (*qLspQueue)[LPCORDER],
IdCelp  *idCelp2,
float   (*qLsp2)[LPCORDER],
float   (*qRes2)[FRM])
{
  CommonExit(1,"IPC_DecParams2ndVR: dummy");
}

void IPC_SynthSC(
int	idVUV,
float	*qLsp,
float	mfdpch,
float	(*am)[3],
float	*qRes,
short int	*frmBuf)
{
  CommonExit(1,"IPC_SynthSC: dummy");
}

void IPC_InterpolateParams(
float		rate,
int		*idVUV2,
float		(*lsp2)[10],
float		*pch2,
float		(*am2)[128][3],
float		(*uvExt2)[160],
int		*modVUV,
float		*modLsp,
float		*modPch,
float		(*modAm)[3],
float		*modUvExt)
{
  CommonExit(1,"IPC_InterpolateParams: dummy");
}


/* end of hvxcDec_dmy.c */
