/*====================================================================*/
/*         MPEG-4 Audio (ISO/IEC 14496-3) Copyright Header            */
/*====================================================================*/
/*
This software module was originally developed by Rakesh Taori and Andy
Gerrits (Philips Research Laboratories, Eindhoven, The Netherlands) in
the course of development of the MPEG-4 Audio (ISO/IEC 14496-3). This
software module is an implementation of a part of one or more MPEG-4
Audio (ISO/IEC 14496-3) tools as specified by the MPEG-4 Audio
(ISO/IEC 14496-3). ISO/IEC gives users of the MPEG-4 Audio (ISO/IEC
14496-3) free license to this software module or modifications thereof
for use in hardware or software products claiming conformance to the
MPEG-4 Audio (ISO/IEC 14496-3). Those intending to use this software
module in hardware or software products are advised that its use may
infringe existing patents. The original developer of this software
module and his/her company, the subsequent editors and their
companies, and ISO/IEC have no liability for use of this software
module or modifications thereof in an implementation. Copyright is not
released for non MPEG-4 Audio (ISO/IEC 14496-3) conforming products.
CN1 retains full right to use the code for his/her own purpose, assign
or donate the code to a third party and to inhibit third parties from
using the code for non MPEG-4 Audio (ISO/IEC 14496-3) conforming
products.  This copyright notice must be included in all copies or
derivative works. Copyright 1996.
*/
/*====================================================================*/
/*======================================================================*/
/*                                                                      */
/*      INCLUDE_FILE:   PHI_EXCQ.H                                      */
/*      PACKAGE:        WDBxx                                           */
/*      COMPONENT:      Tables for Gain Quantization                    */
/*                                                                      */
/*======================================================================*/

#ifndef _phi_excq_h_
#define _phi_excq_h_

/*======================================================================*/
/*     L O C A L    S Y M B O L     D E C L A R A T I O N               */
/*======================================================================*/
#define QLf       31     /* # quantizer levels of fixed codebook gain   */ 
#define QLa       32     /* # quantizer levels of adaptive codebook gain*/
#define QLfd       8     /* # quantizer levels of fixed codebook gain   */

/*======================================================================*/
/*     L O C A L    T Y P E     D E C L A R A T I O N                   */
/*======================================================================*/
struct  table_cb                         /* codebook gain quant. table  */
{
   double dec;
   double rep;
};

#ifdef __cplusplus
extern "C" {
#endif
/*======================================================================*/
/*     TABLE FOR ADAPTIVE CODEBOOK GAIN FACTOR QUANTIZATION             */
/*======================================================================*/
struct table_cb tbl_cba_dir[32] =
{
    0.1622, 0.0945,
    0.2542, 0.2121,
    0.3285, 0.2936,
    0.3900, 0.3597,
    0.4457, 0.4183,
    0.4952, 0.4705,
    0.5425, 0.5186,
    0.5887, 0.5652,
    0.6341, 0.6110,
    0.6783, 0.6559,
    0.7227, 0.7000,
    0.7664, 0.7445,
    0.8104, 0.7884,
    0.8556, 0.8329,
    0.9005, 0.8779,
    0.9487, 0.9242,
    0.9989, 0.9728,
    1.0539, 1.0256,
    1.1183, 1.0849,
    1.1933, 1.1538,
    1.2877, 1.2394,
    1.4136, 1.3465,
    1.5842, 1.4907,
    1.8559, 1.7012,
    2.3603, 2.0636,
    3.8348, 2.8398,
    7.6697, 5.4233,
    15.339, 10.847,
    30.679, 21.693,
    61.357, 43.386,
    122.71, 86.772,
    245.43, 173.54,
};

/*======================================================================*/
/*     TABLE FOR FIXED CODEBOOK GAIN FACTOR QUANTIZATION                */
/*======================================================================*/
struct table_cb tbl_cbf_dir[31] =
{
    2.4726,    2.0,    
    3.1895,    2.8267,
    4.2182,    3.6320,
    5.6228,    4.8605,
    7.3781,    6.4876,
    9.5300,    8.3800,
   12.1013,   10.7813, 
   15.2262,   13.5654,
   19.0319,   17.0676,
   23.6342,   21.1388,
   29.1562,   26.2852,
   35.3606,   32.1299,
   42.8301,   39.0193,
   51.1987,   46.9503,
   60.6440,   55.9060,
   70.9884,   65.7851,
   82.3374,   76.4025,
   95.3755,   88.6170,
  109.8997,  102.7842,
  126.3037,  117.6620,
  144.3995,  135.2277,
  165.5142,  154.7980,
  190.9742,  178.1373,
  220.6299,  204.7267,
  258.2699,  239.0199,
  305.5086,  280.5263,
  368.5894,  334.0282,
  453.5156,  408.3218,
  573.6164,  505.7104,
  801.6422,  665.3362,
  9999.9,    1026.0,  
};

/*======================================================================*/
/*     TABLE FOR FIXED CODEBOOK DIFFERETIAL-GAIN FACTOR QUANTIZATION    */
/*======================================================================*/
struct table_cb tbl_cbf_dif[8] =
{
    0.2500, 0.1000,
    0.5378, 0.3912,
    0.7795, 0.6614,
    1.0230, 0.8954,
    1.3356, 1.1651,
    1.8869, 1.5580,
    4.2000, 2.7000,
    9999.9, 6.5000,
};

#ifdef __cplusplus
}
#endif

#endif  /* #ifndef _phi_excq_h_ */

/*======================================================================*/
/*      H I S T O R Y                                                   */
/*======================================================================*/
/* 17-04-96 R. Taori  Initial Version                                   */
