#include <stdio.h>
#include <stdlib.h>
#include <string.h>

/* CONSTANTS AND GLOBALS */

typedef unsigned char uchar;

#define BUF_SIZE 8192
const char* errmsg[] = { "", "I/O error trying to access", "not an lbx archive:" };


/* PROTOSS */


void error(uchar, const char*);
void extract(char* filename);
char* new_filename(char*, ushort);


/* CODE */


int main(int argc, char* argv[]) {
  int i;

  for (i = 1; i < argc; i++) extract(argv[i]);
  return 0;
}


void extract(char* filename) {
  FILE* in; uint i;
  
  ushort temp16;
  uint temp32;

  ushort file_count;                                                        /* number of files in the archive */
  uint* table;                                                              /* table of file offsets */

  if (!(in = fopen(filename, "rb"))) error(1, filename);
  fread(&file_count, 2, 1, in);                                             /* first word is file_count */

  fread(&temp32, 4, 1, in);
  if (temp32 != 0x0fead) error(2, filename);                                /* then a dword containing a magic number */
  
  fread(&temp16, 2, 1, in);                                                 /* this is garbage (ignored) */
  
  table = malloc(4 * (file_count + 1));                                     /* alloc table; note the +1, there is an EOF
                                                                               entry used to determine the end of the
                                                                               last file, since some garbage might be
                                                                               present at the end of a lbx archive */

  fread(table, 4, file_count + 1, in);                                      /* read table */
  
  for (i = 0; i < file_count; i++) {
    FILE* out; char* fn; uint todo;
    uchar buffer[BUF_SIZE];

    if (!(out = fopen((fn = new_filename(filename, i)), "wb"))) error(1, fn);

    fseek(in, table[i], SEEK_SET);                                          /* not really necessary for files 2+ */
    todo = table[i + 1] - table[i];

    while (todo > 0) {
      uint n = fread(buffer, 1, BUF_SIZE < todo ? BUF_SIZE : todo, in);
      fwrite(buffer, 1, n, out);
      todo = todo - n;
    }

    fclose(out);
    free(fn);
  }

  free(table);                                                              /* end of the story */
}


char* new_filename(char* name, ushort idx) {
  char* rv; char* ptr; int len; 
 
  rv = malloc((len = strlen(name)) + 6 + 1);
  strcpy(rv, name); rv[len] = '.'; 
  sprintf(rv + len + 1, "%i", idx);
  
  return rv;
}


void error(uchar code, const char* details) {
  fprintf(stderr, "Error: %s %s.\n", errmsg[code], details); exit(code);
}


