#include <stdlib.h>

#include <math.h>
#define	PI	3.14159265358979

#ifdef	_MSC_VER	// Microsoft compiler version
#pragma warning(disable:4244)
#endif

#include "noise.h"

#define MAXX 50
#define MAXY 50
#define MAXZ 10

static short noiz_tbl[MAXX][MAXY][MAXZ];

void init_noiz_tbl ()
{
	int i, j, k;

	for (i = MAXX; i-- > 0 ;) {
		for (j = MAXY; j-- > 0 ;) {
			for (k = MAXZ; k-- > 0 ;) {
				noiz_tbl[i][j][k] = rand () % 1000;
			}
		}
	}
	return;
}

double noise (double x, double y, double z)
{
	int ix, iy, iz, ixp, iyp, izp;
	float ox, oy, oz;
	float t1, t2, t3, t4;
	float A,B,C,D,E,F,G,H;

	x += 15000.0;
	y += 15000.0;
	z += 15000.0;
	ix = (int)x % MAXX;
	if (ix < 0)
		ix += MAXX;
	iy = (int)y % MAXY;
	if (iy < 0)
		iy += MAXY;
	iz = (int)z % MAXZ;
	if (iz < 0)
		iz += MAXZ;

	ox = 1.0 - (1.0 + cos (PI * (x - (int)x))) * .5;
	oy = 1.0 - (1.0 + cos (PI * (y - (int)y))) * .5;
	oz = 1.0 - (1.0 + cos (PI * (z - (int)z))) * .5;

	ixp = ix + 1 >= MAXX ? 0 : ix + 1;
	iyp = iy + 1 >= MAXY ? 0 : iy + 1;
	izp = iz + 1 >= MAXZ ? 0 : iz + 1;

	A = (float)noiz_tbl[ix][iy][iz];
	B = (float)noiz_tbl[ixp][iy][iz];
	C = (float)noiz_tbl[ixp][iyp][iz];
	D = (float)noiz_tbl[ixp][iyp][izp];
	E = (float)noiz_tbl[ixp][iy][izp];
	F = (float)noiz_tbl[ix][iy][izp];
	G = (float)noiz_tbl[ix][iyp][izp];
	H = (float)noiz_tbl[ix][iyp][iz];
	t1 = (1.0 - ox) * A + (ox) * B;
	t2 = (1.0 - ox) * H + (ox) * C;
	t3 = (1.0 - ox) * F + (ox) * E;
	t4 = (1.0 - ox) * G + (ox) * D;
	t1 = (1.0 - oy) * t1 + (oy) * t2;
	t2 = (1.0 - oy) * t3 + (oy) * t4;
	t1 = (1.0 - oz) * t1 + (oz) * t2;

	t2 = t1 * .001;
	if (*(long *)&t2 >= 0)
		return t2;
	return 0.0;
}
