#include "imdefs.h"
#include "txdefs.h"

#include <math.h>
#define PI 3.14159265358979

#include "noise.h"

#ifdef	__cplusplus
extern "C" {
#endif

LONG	(*pInit)();
void	(*pCleanup)();

char	szName[18] = "Agate";

BYTE	ubParamFlags[16] = {
	TXTF_SCL,
	TXTF_SCL,
	TXTF_SCL,
	0,0,0,0,
	TXTF_RED,	// TXTF_RED, etc., are ignored now.

	TXTF_GRN,
	TXTF_BLU,
	TXTF_RED,
	TXTF_GRN,
	TXTF_BLU,
	TXTF_RED,
	TXTF_GRN,
	TXTF_BLU,
};

float	fParams[16] = {
	12.0,  9.0,  8.4,  0.0,
	0.6,  0.7,  1.0,  230.0,
	180.0,  155.0,  230.0,  180.0,
	100.0,  180.0,  100.0,  50.0,
};

TFORM	tfAxes = {
	0.0, 0.0, 0.0,

	1.0, 0.0, 0.0,
	0.0, 1.0, 0.0,
	0.0, 0.0, 1.0,

	32.0, 32.0, 32.0,
};

void Work(float *params, PATCH *patch, VECTOR *vector, TFORM *axes)
{
	float   X, Y, Z;
	float	t1;
	float	slopex, slopey, slopez, kx, ky, kz;
	float 	v[14];
	VECTOR  c[14];
	short	m;
	static int precalc = FALSE;

	if (!precalc) {
		// this could be done in an "Init()" routine
		srand (5671);
		init_noiz_tbl();
		precalc = TRUE;
	}

	v[8] = -1.0; 	 v[9] = 0.8;
	v[10] = -1.0; 	 v[11] = 0.9;
	v[12] = -1.0; 	 v[13] = 2.0;

	v[0] = params[3]; 	 v[1] = params[4];
	c[0].X = patch->ptc_col.r; 	c[0].Y = patch->ptc_col.g; 	c[0].Z = patch->ptc_col.b;
	if ((long)(*(long *)&params[7] | *(long *)&params[8] | *(long *)&params[9]) >= 0L) {
		c[1].X = params[7] * 0.00392157;
		c[1].Y = params[8] * 0.00392157;
		c[1].Z = params[9] * 0.00392157;
	} else {
		c[1].X = patch->ptc_col.r;
		c[1].Y = patch->ptc_col.g;
		c[1].Z = patch->ptc_col.b;
	}
	v[2] = params[4]; 	 v[3] = params[5];
	c[2].X = c[1].X; 	c[2].Y = c[1].Y; 	c[2].Z = c[1].Z;
	if ((long)(*(long *)&params[10] | *(long *)&params[11] | *(long *)&params[12]) >= 0L) {
		c[3].X = params[10] * 0.00392157;
		c[3].Y = params[11] * 0.00392157;
		c[3].Z = params[12] * 0.00392157;
	} else {
		c[3].X = patch->ptc_col.r;
		c[3].Y = patch->ptc_col.g;
		c[3].Z = patch->ptc_col.b;
	}
	v[4] = params[5];	 	 v[5] = params[6];
	c[4].X = c[3].X; 	c[4].Y = c[3].Y; 	c[4].Z = c[3].Z;
	if ((long)(*(long *)&params[13] | *(long *)&params[14] | *(long *)&params[15]) >= 0L) {
		c[5].X = params[13] * 0.00392157;
		c[5].Y = params[14] * 0.00392157;
		c[5].Z = params[15] * 0.00392157;
	} else {
		c[5].X = patch->ptc_col.r;
		c[5].Y = patch->ptc_col.g;
		c[5].Z = patch->ptc_col.b;
	}
	v[6] = params[6];	 	 v[7] = 1.1;
	c[6].X = c[5].X; 	c[6].Y = c[5].Y; 	c[6].Z = c[5].Z;
	c[7].X = patch->ptc_col.r;
	c[7].Y = patch->ptc_col.g;
	c[7].Z = patch->ptc_col.b;

	c[8].X = 0.15; 	c[8].Y = 0.15; 	c[8].Z = 0.26;
	c[9].X = 0.1; 	c[9].Y = 0.1; 	c[9].Z = 0.2;
	c[10].X = 0.1; 	c[10].Y = 0.1; 	c[10].Z = 0.2;
	c[11].X = 0.3; 	c[11].Y = 0.3; 	c[11].Z = 0.5;
	c[12].X = 0.3; 	c[12].Y = 0.3; 	c[12].Z = 0.5;
	c[13].X = 0.1; 	c[13].Y = 0.1; 	c[13].Z = 0.2;


	X = vector->X + 10000;
	Y = vector->Y + 10000;
	Z = vector->Z + 10000;
	if (!params[0] || !params[1] || !params[2]) return;
	X /= params[0];
	Y /= params[1];
	Z /= params[2];
	X += noise(X, Y, Z);
	Y += noise(Y, Z, X);
	Z += noise(Z, X, Y);
	t1 = noise (X, Y, Z);
	for (m = 7; m >= 0 ;m -= 2) {
		if ((v[m] >= v[m-1]) && v[m-1] != -1.0 && v[m] != -1.0) {
			if (t1 >= v[m-1] && t1 < v[m]) {
				if (v[m] - v[m-1]) {
					slopex = (c[m].X - c[m-1].X) / (v[m] - v[m-1]);
					slopey = (c[m].Y - c[m-1].Y) / (v[m] - v[m-1]);
					slopez = (c[m].Z - c[m-1].Z) / (v[m] - v[m-1]);
					kx = c[m-1].X - slopex * v[m-1]; /* red */
					ky = c[m-1].Y - slopey * v[m-1]; /* green */
					kz = c[m-1].Z - slopez * v[m-1]; /* blue */
					patch->ptc_col.r = slopex*t1 + kx;
					patch->ptc_col.g = slopey*t1 + ky;
					patch->ptc_col.b = slopez*t1 + kz;
					if (m == 1 || m == 7) {
						patch->ptc_tra.r = patch->ptc_tra.r;
						patch->ptc_tra.g = patch->ptc_tra.g;
						patch->ptc_tra.b = patch->ptc_tra.b;
						patch->ptc_ref.r = patch->ptc_ref.r;
						patch->ptc_ref.g = patch->ptc_ref.g;
						patch->ptc_ref.b = patch->ptc_ref.b;
					} else {
						patch->ptc_tra.r = 0.0;
						patch->ptc_tra.g = 0.0;
						patch->ptc_tra.b = 0.0;
						patch->ptc_ref.r = 0.0;
						patch->ptc_ref.g = 0.0;
						patch->ptc_ref.b = 0.0;
					}
				}
			}
		}
	}
}

#ifdef	__cplusplus
};
#endif
