/****************************************************************************
 *
 * Outlook File format decoder
 *
 ****************************************************************************
 *
 * File: outlook.h
 *
 * Copright (c) 1998 Tom Gallagher (teg@cableinet.co.uk)
 * 
 * Based on initial work by Michael Santovec (michael_santovec@prodigy.net)
 * and Jeff Evans (evansj@shaw.wave.ca)
 *
 *
 * This is not a very complete program but there should be enough info
 * here for people to create programs to browse their outlook messages
 * from other OS's if required.  Could also be used to import outlook
 * messages into other mail readers.
 *
 */

#ifndef __OUTLOOK_H
#define __OUTLOOK_H

#include <stdio.h>
#include <time.h>
#include "common.h"

/*
 * All structures are tightly packed within the IDX and MBX file
 */
#pragma pack(1)

/*
 * IDX File header
 */
typedef struct {
	DWORD Magic;    /* JMF9 (IDX) */
	DWORD Version;  /* A file format version number?? */
	DWORD nItems;   /* No. entries in this IDX file (no. msgs in MBX file) */
	DWORD nBytes;   /* No. bytes in the IDX file */ 
	DWORD Unk1;
	DWORD Unk2;
	BYTE  Pad[40];
	BYTE  Pad2[16];
} IDX_HDR;


/*
 * MBX File Header
 */
typedef struct {
    DWORD Magic;            /* JMF6 */
    DWORD Version;          /* ? 03000101 ? */
    DWORD nMsgs;            /* No. msgs including those marked for deletion */
    DWORD LastUsedMsgNum;
    DWORD nBytes;           /* Size of the MBX file in bytes */
    BYTE  Pad[64];
} MBX_HDR;

    
/*
 * Strings are variable length and prefixed with their length (DWORD)
 *
 * This structure is an internal program representation of a string.
 *
 * The strings in the file appear to all be NULL terminated.
 */
typedef struct {
	DWORD Length;
	BYTE  *Data;
} IDX_STRING;


/*
 * Internet Header data Parsed from the message itself
 */
typedef struct {
    DWORD DataSize;     /* Struct Len + String Lengths */

    DWORD Pad6;         /* Perhaps 64 bit data size ?? (always 0) */
	FILETIME Received;
	FILETIME Sent;
	WORD  Priority;		/* Priority */

} IDX_MSG_INFO;

/*
 * Description of each part of a multi part MIME or UUENCODED message
 */
typedef struct {

        DWORD Pad[7];
        DWORD DataStart;    /* Offset to the data for this part of a multi part MIME*/
        DWORD DataEnd;      /* Offset to the end of the data (points one char past the end)*/

        /* Start of headers for this part of the multi part MIME or UUENCODE message */
        DWORD HeaderStart;  /* Offset to the start of the headers for this section only */

        DWORD Pad1;
        DWORD Idx;

        /* 
         * Pointer to the start of the multi part boundary line
         * For UUENCODED messges this is the same as header start because
         * the start of the headers represents the boundary too.
         */

        DWORD BoundaryOffset;

        DWORD Pad2[10];

} IDX_PART;

/*
 * Every entry in the MBX file has a 16 byte header
 */
typedef struct {
    DWORD Magic;        /* 0x7F007F00 */
    DWORD Idx;          /* Index in the MBX file */
    DWORD TotalLen;     /* Total Length taken by this entry */
    DWORD MsgLen;       /* Total length of all message data */
} MBX_MSG_HDR;
    
#define MBX_MSG_HDR_LEN     (0x10)

typedef struct {
	DWORD Flags;
	DWORD Unk1;			/* Always zero ? */
	DWORD EntryNum;		/* Index Number */
	DWORD FilePos;		/* Position from the start of the file to this header */
	DWORD nBytes;		/* Number of bytes in this index entry */
	DWORD MBXOffset;  	/* Offset of message data in the mbx file */
	DWORD MBXSize;		/* Total Size of the message + header in MBX file  */
    BYTE  Pad5[6];
    WORD  Attach;       /* Flags to do with Attachments ?? */
    BYTE  Pad1[4];
    WORD  Pad2;
    DWORD MsgSize;      /* Total data length of message */
    DWORD nAttachBytes; /* Number of bytes in the next attachment section in this file*/   
    BYTE  Pad3[48];
    DWORD nSeparators;  /* Number of MIME or (UUENCODE) sections + 1 */
    BYTE  Pad4[12];
    DWORD   Flag1;
    DWORD   Flag2;
    DWORD   Offset;     /* Offset to actual message data (skipping Internet headers) */
    DWORD   Pad[15];    
} IDX_MSG_HDR;

typedef struct {

    IDX_MSG_HDR     IdxEntry;
    IDX_MSG_INFO    MsgInfo;
    IDX_PART     *  pParts;
   
    IDX_STRING Subject;
    IDX_STRING Sender;
    IDX_STRING POPServer;
    IDX_STRING Username;
    IDX_STRING MailAccount;
    IDX_STRING POP3Login;
    IDX_STRING AccDesc;     /* Mail Account Friendly Name! */

} MAILMSG;

/*
 * Helper macros to obtain the strings from the ith message
 * in mailbox p
 */
#define SUBJECT(p,i)    p->pMsgs[i].Subject.Data
#define SENDER(p,i)     p->pMsgs[i].Sender.Data
#define POPSERVER(p,i)  p->pMsgs[i].POPServer.Data
#define USERNAME(p,i)   p->pMsgs[i].Username.Data
#define MAILACCOUNT(p,i) p->pMsgs[i].MailAccount.Data
#define POPLOGIN(p,i)   p->pMsgs[i].POP3Login.Data
#define ACCDESC(p,i)    p->pMsgs[i].AccDesc.Data

#define SENT(p,i)       p->MsgInfo.Sent
#define RECEIVED(p,i)   p->MsgInfo.Received


typedef struct {
    FILE *  fptrMBX;
    FILE *  fptrIDX;
    IDX_HDR IdxHdr;
    MBX_HDR MbxHdr;
    MAILMSG * pMsgs;
} MAILBOX;

int ReadIdxString(MAILBOX *pMailBox,IDX_STRING *Str);
int ReadIdxMsgHdr(MAILBOX *pMailBox,IDX_MSG_HDR *Entry);
int ReadIdxMsgInfo(MAILBOX *pMailbox,IDX_MSG_INFO *pMsgInfo);
int ReadIdxPart(MAILBOX *pMailbox, IDX_PART *pPart);
int ReadMailMsg(MAILBOX *pMailBox,MAILMSG *pMsg);
int CloseMailBox(MAILBOX *pMailBox);
MAILBOX * OpenMailBox(char * Mailbox);
time_t GetMsgSentTime(MAILBOX *pMailBox,DWORD Idx);
time_t GetMsgReceivedTime(MAILBOX *pMailBox,DWORD Idx);


#define IDX_MAGIC	(0x39464d4a)
#define MBX_MAGIC   (0x36464d4a)

#endif

