/****************************************************************************
 *
 * Outlook File format decoder
 *
 ****************************************************************************
 *
 * File: outlook.c
 *
 * Copright (c) 1998 Tom Gallagher (teg@cableinet.co.uk)
 * 
 * Based on initial work by Michael Santovec (michael_santovec@prodigy.net)
 * and Jeff Evans (evansj@shaw.wave.ca)
 *
 *
 * This is not a very complete program but there should be enough info
 * here for people to create programs to browse their outlook messages
 * from other OS's if required.  Could also be used to import outlook
 * messages into other mail readers.
 *
 */

#include "outlook.h"
#include <malloc.h>

#define DBG(s)  s

time_t GetMsgSentTime(MAILBOX *pMailBox,DWORD Idx)
{
    DWORD Rem;
    return FileTimeToUnixTime(&pMailBox->pMsgs[Idx].MsgInfo.Sent,&Rem);
}

time_t GetMsgReceivedTime(MAILBOX *pMailBox,DWORD Idx)
{
    DWORD Rem;
    return FileTimeToUnixTime(&pMailBox->pMsgs[Idx].MsgInfo.Received,&Rem);
}

/*
 * Read a variable length string from the IDX file.
 */
int ReadIdxString(MAILBOX *pMailBox,IDX_STRING *Str)
{
    /*
     * Read the 4 byte length value
     */
	if (1 != fread(&Str->Length,sizeof(DWORD),1,pMailBox->fptrIDX))
	{
		DBG(printf("Error reading string length\n"));
		return FALSE;
	}

	DBG(printf("String Length: %d\n",Str->Length));


     if (Str->Length > 2048) {

        DBG(printf("String Too Long!!\n"));

        return FALSE;

     } 

    /*
     * Allocate Length + 1 bytes
     * This routine specifically null terminates the strings
     * although they appear to have a terminating null stored
     * in the file anyway.
     */
    
	Str->Data = malloc(Str->Length+1);
	
	if (!Str->Data)
	{
		DBG(printf("Mem alloc err ReadString\n"));
		return FALSE;
	}
	
	if (1 != fread(Str->Data,Str->Length,1,pMailBox->fptrIDX))
	{
		DBG(printf("String Data Read Error\n"));
		return FALSE;
	}
	
	/* Null Terminate */

	Str->Data[Str->Length] = '\0';

	DBG(printf("String Data: %s\n",Str->Data));
			
	return TRUE;
}


/*
 * Read the information that is at the start of each
 * index entry in the IDX file.
 */
int ReadIdxMsgHdr(MAILBOX *pMailBox,IDX_MSG_HDR *Entry)
{

    int i,j;

	memset(Entry,0,sizeof(IDX_MSG_HDR));
	
	if (1 != fread(Entry,sizeof(IDX_MSG_HDR),1,pMailBox->fptrIDX))
	{
		DBG(printf("Entry Read Error\n"));
		return FALSE;
	}


	DBG(printf("Flags %08X\n",Entry->Flags));
	DBG(printf("Entry Num %d\n",Entry->EntryNum));
	DBG(printf("nBytes %d (%08X))\n",Entry->nBytes,Entry->nBytes));

	DBG(printf("Unk1      : %08X\n",Entry->Unk1));
	DBG(printf("MBXOffset : %08X\n",Entry->MBXOffset));
	DBG(printf("MBXSize   : %d (%08X))\n",Entry->MBXSize,Entry->MBXSize));
    DBG(printf("MsgSize   : %d (%08X))\n",Entry->MsgSize,Entry->MsgSize));

    DBG(printf("(diff))    : %d\n",Entry->MBXSize-Entry->MsgSize));

    DBG(printf("nAttach   : %d (%08X))\n",Entry->nAttachBytes,Entry->nAttachBytes));

    DBG(printf("Separators: %d\n",Entry->nSeparators));

    DBG(printf("Padding   : "));

    for(i=0;i<6;i++)

        DBG(printf("%02X ",Entry->Pad5[i]));



    DBG(printf("\n"));

    DBG(printf("Padding3  : \n"));



    for(j=0;j<4;j++) {

        DBG(printf("            "));

        for (i=0;i<16;i++)

            DBG(printf("%02X ",Entry->Pad3[j*16+i]));

        DBG(printf("\n"));

    }    



    return TRUE;

}



int ReadIdxMsgInfo(MAILBOX *pMailbox,IDX_MSG_INFO *pMsgInfo)
{
    memset(pMsgInfo,0,sizeof(IDX_MSG_INFO));

    if (1 != fread(pMsgInfo,sizeof(IDX_MSG_INFO),1,pMailbox->fptrIDX))
    {
        DBG(printf("MsgInfo Read Error\n"));
        return FALSE;
    }

    DBG(printf("Priority  : %04X\n",pMsgInfo->Priority));

    return TRUE;
}

int ReadIdxPart(MAILBOX *pMailbox, IDX_PART *pPart)

{
    int i;

    memset(pPart,0,sizeof(IDX_PART));

    if (1 != fread(pPart,sizeof(IDX_PART),1,pMailbox->fptrIDX))
    {
        DBG(printf("Part Read Error\n"));
        return FALSE;
    }

    return TRUE;
}

int CloseMailBox(MAILBOX *pMailBox)
{
    int i;
    
    for(i=0;i<pMailBox->IdxHdr.nItems;i++)
    {
        free(pMailBox->pMsgs[i].pParts);
    }
    
    free(pMailBox->pMsgs);
    
    fclose(pMailBox->fptrIDX);
    fclose(pMailBox->fptrMBX);
    
    free(pMailBox);
    
    return TRUE;
}
    


MAILBOX * OpenMailBox(char * Mailbox)
{
    int i;
    char Index[128];
    char MBX[128];    

    MAILBOX *pMailBox = malloc(sizeof(MAILBOX));

    strcpy(Index,Mailbox);
    strcat(Index,".idx");
    strcpy(MBX,Mailbox);
    strcat(MBX,".mbx");


	if (NULL==(pMailBox->fptrIDX=fopen(Index,"rb")))
	{
		DBG(printf("Error Opening file - %s\n",Index));
		return NULL;
	}

	if (NULL==(pMailBox->fptrMBX=fopen(MBX,"rb")))
	{
		DBG(printf("Error Opening file - %s\n",MBX));
		return NULL;
	}

	if (1 != fread(&pMailBox->IdxHdr,sizeof(IDX_HDR),1,pMailBox->fptrIDX))
	{
		DBG(printf("IDX Header Read Error\n"));
		return NULL;
	}

	if (1 != fread(&pMailBox->MbxHdr,sizeof(MBX_HDR),1,pMailBox->fptrMBX))
	{
		DBG(printf("MBX Header Read Error\n"));
		return NULL;
	}

	if (pMailBox->IdxHdr.Magic != IDX_MAGIC)
	{
		DBG(printf("Not an outlook index file\n"));
		return NULL;
	}

	if (pMailBox->MbxHdr.Magic != MBX_MAGIC)
	{
		DBG(printf("Not an outlook MBX file\n"));
		return NULL;
	}


	DBG(printf("Version %08X\n",pMailBox->IdxHdr.Version));
	DBG(printf("n Items  %d\n",pMailBox->IdxHdr.nItems));
	DBG(printf("File Size %d\n",pMailBox->IdxHdr.nBytes));

    pMailBox->pMsgs = malloc(pMailBox->IdxHdr.nItems * sizeof(MAILMSG));

    if (!pMailBox->pMsgs)
    {
        DBG(printf("Error allocating memory for message indexes\n"));
        return NULL;
    }        
   
    for (i=0;i<pMailBox->IdxHdr.nItems;i++)
    {
        ReadMailMsg(pMailBox,&pMailBox->pMsgs[i]);
    }

    return pMailBox;
}

void DumpMBX(MAILBOX *pMailBox,DWORD Offset,DWORD Len)
{
    DWORD i;

    printf("Offset    : %08X\n",Offset);
    printf("Data      : ");

    fseek(pMailBox->fptrMBX,Offset,SEEK_SET);

    for(i = 0 ;i<Len;i++) {
        int ch = fgetc(pMailBox->fptrMBX);
        printf("%c",ch > 31 ? ch : '.');
    }
    printf("\n");
}        

int ReadMailMsg(MAILBOX *pMailBox,MAILMSG *pMsg)
{
    long  CurPos = 0;
	DWORD Rem = 0;
	int i = 0;

	DBG(printf("************************\n"));
	

	CurPos = ftell(pMailBox->fptrIDX);

/*
 * Read the Message Index Entry Header
 */
    ReadIdxMsgHdr(pMailBox,&pMsg->IdxEntry);


//    DumpMBX(fptrMBX,Entry->IdxEntry.MBXOffset + MBX_MSG_HDR_LEN + Entry->IdxEntry.Offset,25);
                   

/*
 * Read the multi part MIME descriptions (if any)
 */
 
    pMsg->pParts = malloc(sizeof(IDX_PART) * pMsg->IdxEntry.nSeparators);

    for (i=0;i<pMsg->IdxEntry.nSeparators;i++)
    {
        int j;
        
        ReadIdxPart(pMailBox,&pMsg->pParts[i]);
        DBG(printf("****\n"));

        DBG(printf("Pad:\n"));
        for (j=0;j<7;j++)
            DBG(printf("%08X ",pMsg->pParts[i].Pad[j]));

        DBG(printf("\n"));

        DBG(printf("Pad2:\n"));
        for (j=0;j<10;j++)
            DBG(printf("%08X ",pMsg->pParts[i].Pad2[j]));

        DBG(printf("\n"));
        DBG(printf("Pad1      : %d (%08X)\n",pMsg->pParts[i].Pad1,pMsg->pParts[i].Pad1));
        DBG(printf("Idx?      : %d (%08X)\n",pMsg->pParts[i].Idx ,pMsg->pParts[i].Idx ));        

        DBG(printf("\n"));            

        DBG(DumpMBX(pMailBox,pMsg->pParts[i].DataStart + pMsg->IdxEntry.MBXOffset+MBX_MSG_HDR_LEN,80));
        DBG(DumpMBX(pMailBox,pMsg->pParts[i].DataEnd + pMsg->IdxEntry.MBXOffset+MBX_MSG_HDR_LEN,80));
        DBG(DumpMBX(pMailBox,pMsg->pParts[i].HeaderStart + pMsg->IdxEntry.MBXOffset+MBX_MSG_HDR_LEN,80));
        DBG(DumpMBX(pMailBox,pMsg->pParts[i].BoundaryOffset + pMsg->IdxEntry.MBXOffset+MBX_MSG_HDR_LEN,80));
        DBG(printf("****\n"));
    }



    /* 50 */

/*
 * Position the file pointer to the trailing data
 */

    fseek(pMailBox->fptrIDX,CurPos+pMsg->IdxEntry.nAttachBytes+0x32,SEEK_SET);

/*
 * Read the trailing message information
 */
    
    ReadIdxMsgInfo(pMailBox,&pMsg->MsgInfo);

/*
 * Read the variable length string data
 */
 
	 if (!ReadIdxString(pMailBox,&pMsg->Subject))
	 {
	 	//return NULL;
	 }
	
	 if (!ReadIdxString(pMailBox,&pMsg->Sender))
	 {
	 	//return NULL;
	 }

	 if (!ReadIdxString(pMailBox,&pMsg->POPServer))
	 {
	 	//return NULL;
	 }

	 if (!ReadIdxString(pMailBox,&pMsg->Username))
	 {
	 	//return NULL;
	 }

	 if (!ReadIdxString(pMailBox,&pMsg->MailAccount))
	 {
	 	//return NULL;
	 }

	 if (!ReadIdxString(pMailBox,&pMsg->POP3Login))
	 {
	 	//return NULL;
	 }

	 if (!ReadIdxString(pMailBox,&pMsg->AccDesc))
	 {
	 	//return NULL;
	 }


/*
 * Position the file pointer to the start if the next index entry
 */

	fseek(pMailBox->fptrIDX,CurPos+pMsg->IdxEntry.nBytes,SEEK_SET);
}

