unit BabylonDemoUnit;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Babylon;

type
  TForm1 = class(TForm)
    Babylon1: TBabylon;
    Translate: TButton;
    EnglishWord: TEdit;
    Label1: TLabel;
    ResultsMemo: TMemo;
    Label2: TLabel;
    Label3: TLabel;
    TargetLanguage: TComboBox;
    Label4: TLabel;
    DataPath: TEdit;
    Change: TButton;
    DICdialog: TOpenDialog;
    procedure TranslateClick(Sender: TObject);
    procedure ChangeClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.TranslateClick(Sender: TObject);
var c:integer;
begin
 case babylon1.Translate (EnglishWord.text,DataPath.text,TargetLanguage.text) of
  0: begin
      resultsMemo.clear;
      for c:=1 to Babylon1.resultscount do
       ResultsMemo.lines.append (babylon1.results[c]);
     end;
  1: begin
      application.messagebox (pchar ('No words beginning with '+copy (EnglishWord.text,1,3)),'Error',mb_ok);
     end;
  2: begin
      application.messagebox (pchar ('No words beginning with '+copy (EnglishWord.text,1,3)+' with length of '+inttostr (length (EnglishWord.text))),'Error',mb_ok);
     end;
  3: begin
      application.messagebox (pchar ('The word '+EnglishWord.text+' is not in the dictionary'),'Error',mb_ok);
     end;
  4: begin
      application.messagebox (pchar ('Cant open the appropriate .DIC files'),'Error',mb_ok);
     end;
 end;
end;

procedure TForm1.ChangeClick(Sender: TObject);
var t:string;
begin
 DICdialog.filename:='Egnlish.dic';
 if DICDialog.execute then begin
  t:=DicDialog.FileName;
  while (t<>'') and (t[length (t)]<>'\') do t:=copy (t,1,length (t)-1);
  if fileexists (t+'English.dic') then begin
   Datapath.text:=t;
  end else application.messagebox ('English.dic can not be found in this location !','Error',mb_ok);
 end;
end;

procedure TForm1.FormActivate(Sender: TObject);
begin
 TargetLanguage.itemindex:=0;
end;

end.
