#include <stdio.h>
#include <io.h>
#include <windows.h>
#include "oe5.h"

void 		oe5__import_message(HFILE hFile,oe5__message_dir *pMessages,long lMessages,long lMessage);
void 		oe5__import(LPSTR szFilename);

void main(int,char *argv[])
{
	oe5__import(argv[1]);
}

void oe5__import(LPSTR szFilename)
{
HFILE             hFile;
long              lMessage,lPos,lMessages;
long              lPercent;
oe5__message_dir *pMessages;
HANDLE            hMessages;
BOOL              bFirst;

        hFile=_lopen(szFilename,OF_READ);

        _llseek(hFile,0x30,0);
        _lread(hFile,&lPos,sizeof(long));  // This points to the lookup table for the messages

        lMessages=0;

        do {
                _llseek(hFile,lPos+24,0);	// The first 4 bytes are set to the value of the file position, the next 20 bytes are unknown.

                bFirst=TRUE;
                do {
                        _lread(hFile,&lMessage,sizeof(long));

                        _llseek(hFile,8L,1);
                        if(lMessage!=0) {
                                lMessages++;
                                bFirst=FALSE;
                        }
                } while(lMessage!=0 && tell(hFile)<lPos+0x27c);
                if(bFirst && lMessage==0) break;
                lPos+=0x27c;			// The next table is 0x27c bytes on from the start of this one
        } while(TRUE);

        hMessages=GlobalAlloc(GMEM_MOVEABLE | GMEM_ZEROINIT,lMessages*sizeof(oe5__message_dir)); // we now need to allocate space so we can remember the table
        if(hMessages!=NULL) {
                pMessages=(oe5__message_dir *)GlobalLock(hMessages);
                lMessages =0;

                _llseek(hFile,0x30,0);
                _lread(hFile,&lPos,sizeof(long));		// Start again

                do {
                        _llseek(hFile,lPos+24,0);

                        bFirst=TRUE;
                        do {
                                _lread(hFile,&lMessage,sizeof(long));
                                _llseek(hFile,8L,1);
                                if(lMessage!=0) {			// Values sometimes get repeated.  This results in us seeing the message twice, so make sure we only get the value once
                                        int  n;
                                        BOOL bOk;

                                        bOk=TRUE;
                                        for(n=0;n<lMessages && bOk;n++) {
                                                if((pMessages+n)->lTable==lMessage) bOk=FALSE;
                                        }
                                        if(bOk) (pMessages+lMessages++)->lTable=lMessage;
                                        bFirst=FALSE;
                                }
                        } while(lMessage!=0 && tell(hFile)<lPos+0x27c);
                        if(bFirst && lMessage==0) break;
                        lPos+=0x27c;
                } while(TRUE);

                for(lMessage=0;lMessage<lMessages;lMessage++) {
                        _llseek(hFile,(pMessages+lMessage)->lTable,0);
                        oe5__import_message(hFile,pMessages,lMessages,lMessage);   // Import the message

                        lPercent=(lMessage*100)/lMessages;

                        printf("%ld%%\r",lPercent);
                }
                GlobalUnlock(hMessages);
                GlobalFree(hMessages);
        }
        _lclose(hFile);
}

void oe5__import_message(HFILE hFile,oe5__message_dir *pMessages,long lMessages,long lMessage)
{
oe5__message_header MessageHeader;
oe5__message_table  Table;
HANDLE              hMessage;
LPSTR               szMessage,szPtr;
long                lTextSize,n;
FILE               *File;
char                szFilename[260];

	_lread(hFile,&Table,sizeof(oe5__message_table));

        Table.lPos&=0xffffff;		// Mask out high byte.  This is a 3 byte value

        for(n=0;n<lMessages;n++) {
        	if((pMessages+n)->lMessage==Table.lPos) return;		// We've already done this message
        }
        (pMessages+lMessage)->lMessage=Table.lPos;

        _llseek(hFile,Table.lPos,0);
        _lread(hFile,&MessageHeader,sizeof(oe5__message_header));

        if(MessageHeader.lFlags==0x01fc) return;  // 0x01fc appears to indicate that the message is deleted

        lTextSize=0;

        do {
        	lTextSize+=MessageHeader.lSectionSize;
                if(MessageHeader.lNextHeader==0) break;

                _llseek(hFile,MessageHeader.lNextHeader,0);
                _lread(hFile,&MessageHeader,sizeof(oe5__message_header));		// The messages are chained together in chunks.
        } while(TRUE);

        hMessage=GlobalAlloc(GMEM_MOVEABLE,lTextSize);					// Now we know how big it is allocate space for it and go through the list again reading the message text
        if(hMessage!=NULL) {
                szMessage=(LPSTR)GlobalLock(hMessage);

                _llseek(hFile,Table.lPos,0);
                _lread(hFile,&MessageHeader,sizeof(oe5__message_header));

		szPtr=szMessage;

                do {
                	_lread(hFile,szPtr,MessageHeader.lSectionSize);
                        szPtr+=MessageHeader.lSectionSize;

                        if(MessageHeader.lNextHeader==0) break;

                        _llseek(hFile,MessageHeader.lNextHeader,0);
	                _lread(hFile,&MessageHeader,sizeof(oe5__message_header));
        	} while(TRUE);

                sprintf(szFilename,"%ld.txt",lMessage);				// Dump it to a text file
                File=fopen(szFilename,"w");
                fwrite(szMessage,lTextSize,1,File);
                fclose(File);

                GlobalUnlock(hMessage);
                GlobalFree(hMessage);

                return;
        }
}

