/* --- PKBOR.H ------------------------------------------------------
**
** This file defines and explains hypertext style file structure
** used by Borland Intl. products. This method achieves suprisingly
** good compression with very simple and elegant methods -
** hence the funny name, derived from PKWare's trade marks and
** BORland. It doesn't get near to PKZIP 75% compression, but still
** reduces original file to about 65% of original size.
**
** The secrets were broken by:
**
** Aare Tali, Madis Kaal.
**
** Borland hasn't ever released this information, so please do
** not tell them, that you know :) This is also a reason why we cannot
** claim that this file is (C) of ours...
**
** Aug-1991
*/

typedef byte hfptr[3];        /* 3 byte pointer */

/*
** Help file starts with string terminated by 0x00,0x1a sequence.
** After 0x1a, the header follows...
*/

struct filehdr {
        byte    fileID[13]; /* "$*$* &&&&$*$\0" */
        byte    version;    /* 0x33 for BC++ 2.0 & TURBO 6.0
                               0x05 for TC++ 1.x & TASM 2.x
                               0x04 for TC 2.x */
                            /* next 5 words seem to be insignificant
                               to all products, however if you change
                               the original file, keep them same */
        word    const1;     /* 0x0001 */
        word    const2;     /* 0x0009 */
        word    const3;     /* 0x0004 */
        word    const4;     /* 0x0002 | 0x0064 */
        word    const5;     /* variable... (date?) */

        byte    wnd_rows;   /* max rows */
        byte    wnd_cols;   /* max columns */
        byte    txt_offs;   /* text offset in window from left side */
        byte    const6;     /* 0x05 changing it causes TC 2.x to crash
                               but BC++ 2.0 has no problems */
        word    const7;     /* 0x000f */
        byte    const8;     /* 0x02 */
        byte    table[14];  /* 14 most used bytes */
        byte    const9;     /* 0x01 */
        word    offset1;    /* offset from EOH to TOC */
        word    tot_pages;  /* total pages */
        hfptr   const10;    /* 0xffffff, page #0 pointer */
};

/*
** EOH - End Of Header
** TOC - Table Of Contents
**
** Header is followed by indexes, tot_pages of them
**
** hfptr index[tot_pages];
**
** As page #0 cannot be accessed by hyperlinks, it is left unused.
** Pointer number 0 is set to 0xffffff, in the index table some
** indexes are set to 0xfffffe (for reason not yet discovered by us).
*/

struct tochdr {
        byte    hdrsize;    /* 0x04, looks like additional byte count */
        word    size;       /* size of TOC */
        word    count;      /* number of items in TOC */
};

/*
** TOC is compressed in form
**
** pseudostruc _tocitem {
**      int keep : 3;       /* most significant bits */
**      int new  : 5;       /* these make up one byte */
**      byte text[new];     /* new characters to add */
**      word page;          /* page # , index[page] will give offset to data */
** };
**
** The first byte tells us how many characters we have to keep from last
** string and how many new characters we have to add to get a new string.
** This does fairly good job on _sorted_ strings. And table of contents
** is a sorted thing.
*/

/*
** Data is compressed in form {
**
** pseudostruc _datapage {
**      byte type;          /* constant 0x02 */
**      word size;          /* bytes of compressed data */
**      byte data[size];    /* actual data */
** };
*/

/*
** At least BC++ has no intrest to real index, it uses the special
** index page. The 'constant' page numbers for BC++ are:
**
** 1    Welcome page (help on help)
** 2    Contents
** 3    No help, page to be shown for undefined links.
** 4    Index page
*/

/*
** After you have decoded the page, you'll find some control characters
** in the resulting text. The ones we have found this far are:
**
** 0x01 Mystery, seems to be just a dummy byte used to finish the page.
**      You should not rely on it, sometimes it is at end of page,
**      sometimes it isn't. The reason why it is used at ill is probably
**      that page length is given in bytes, but data is nibble-coded. This
**      could leave one additional nibble unused, but specified in length.
**      In such case this nibble is set to 0xf and next byte (not shown in
**      page size) is set to 0x10 (which decodes to 0x01).
** 0x02 Hyperlink frame.
** 0x05 Example text frame.
*/

/*
** Each data page is followed by hyperlink page.
**
** There is a major difference in hyperlink handling for TC 2.x
** file and new format files. New files have hyperlinks surronded
** in text, but in old format file, they're not marked. So they
** have to be hardcoded into link table (making scrolling virtually
** impossible). Old file has also a limit of 255 links per one subpage.
**
** typedef struct {
**        byte row;         /* text row */
**        byte scol;        /* starting column */
**        byte ecol;        /* ending column */
**        byte up;          /* link numbers to move to */
**        byte right;       /* when any arrow is pressed. */
**        byte left;
**        byte down;
**        word page;        /* page which contains data for this link */
** } OLINK;
**
** typedef struct {
**        word page;        /* this is all what new layout needs */
** } NLINK;
**
** pseudostruc _linkpage {
**        byte type;        /* constant 0x03 */
**        word size;        /* total bytes following (size=count+3) */
**        word back;        /* page number for previous subpage */
**        word forw;        /* page number for next subpage */
**                          /* here the help file format differs, this is
**                           for new files */
**        word count;        /* number of links for this page */
**        NLINK links[count];/* new type links */
**                           /* and this is for old type files */
**        byte count;        /* old files have 255 link limit for frame */
**      OLINK links[count];  /* old type links */
** };
*/

/*
** Data page is coded in nibbles. Lower nibble must be processed first.
**
** The generic decode algorithm for one data byte:
**
** byte read_byte(void) {
**    byte outbyte;
**    int n;
**    n=read_nibble();
**    if (n<14)
**        outbyte=header.table[n];
**    else if (n==14)
**        outbyte=14;
**    else {
**        outbyte=read_nibble();
**        outbyte+=(read_nibble()<<4);
**    }
**    return outbyte;
** }
**
** The output value of 14 means that RLE compressed data follows.
** note that space must be reserved for at least 17 bytes.
**
** void decompress(char *buf) {
**    int i;
**    byte data;
**    i=read_nibble()+2; /* no point to compress less than 3... */
**    data=read_byte();  /* get data byte */
**    while (i-->0)
**       *buf++=data;    /* expand the data */
**  }
*/
