; This is work in progress.. and unverified.

DUMMY1                  DD      (0)
DUMMY2                  DD      (0FF)
NUM_RECS                DD      DUP (?)         ; number of records (para)
                                                ; num_recs*20h= FIELDS offset
SORTCODE                DB      (?)             ; Sort Condition of file
                                                ; SORT CODES
                                                ; 0 = THREAD
                                                ; 1 = SUBJECT
                                                ; 2 = AUTHOR
                                                ; 3 = DATE
                                                ; 4 = ???
                                                ; 5 = SIZE (LINES)
JUNK                    DB      15d DUP (?)     ; fill

MSG_IDX                 STRUC
UID                     DD      (?)             ; starting page in .DAT
HID                     DD      (?)             ; hashed messageID
NUM                     DD      (?)             ; message number on server
THDREF                  DD      (?)             ; ref'd by msgs in "thread"
; The makeup of the THDREF is unknown.
; However:
;       1. All threaded messages have the same THDREF
;       2. Changing the subject when replying creates a new "thread".
;       3. Agent may generate "it's" messageIDs (and servers may ignore them)
;       4. RefID = 0,or non0 when header is retrieved
;       5. Messages with a References: Tag have non0 refID, otherwise 0
;          (Agent gets the REF with the header and uses it)

REFID                   DD      (?)             ; HID of the Reference message
;          "Re:" is inserted in the subject of headers with non0 REFIDS

LINESWRD                DW      (?)             ; #lines shown in msglist_pane
STWRD                   DW      (?)             ; Flags bitmap
; Controls Index "view", encodes the Status Icons (In the msglist pane),
; and controls the Index display.
; Whether to display it, and to some degree what to show.)
; Defaults are refined by what Agent obtains when it retrieves headers.
; Format is x yy z (or x y1 y2 z)
; 1. x= Icon to display (Not the color)
;    0     = None
;    4,8,C = Page
;    2,6   = Mail
;    Others not observed, and may produce "strange" results
;    in combination with values in other nibbles.
; 2. y1 may contain transfer encoding to presume.
; 3. y2 appears to contain an error code
; 4. z has values
;    1,2   = Bare Header (no pagelist)
;    A     = Has pagelist (message retrieved, or combined)
;          02 1A Incomplete  => 00 02 after splitting
;
; 5. Some generalizations
;    ??12 = Not avail  Icon
;    ??1A = Incomplete Icon
;    ??02 = No         Icon
;    Other values of x will display either a page or mail icon,
;    and allow display of an index, but info may/may not be correct.
;    When a body is deleted, the x value is retained.
; 6. Observed values, 1st version using and "meaning" (all rough),
;    since my databases contain headers from several versions.
;    For my purposes, the FreeAgent and OLD info is sufficient.
;
; 00 02   A101    Header
; 00 22   A101    Header
; 01 02   A101    Header
; 02 1A   ????    Unavailable
; 41 02   A101    Body
; C0 0A   A101    Body Saved/Purged
; C0 02   A101    Body Deleted
; 40 0A   A99e    Body Saved/Purged
; 41 0A   A101    Body Saved/Purged
; 01 22   A101    Header
; 00 01   FA10    Header
; 80 89   FA10    Body Saved
; 80 09   FA10    Body
; C0 8A   FA??    Body Saved
; 00 21   FA10    Header
; 60 0A   Mail    Body
; 60 2A   Mail    Body
; 40 8A   A99e    Body Saved

DATETIME                                        ; in UNIX time_t format
TIMEWORD                DW      (?)             ; time
DATEWORD                DW      (?)             ; date (origin is available)
LEN#                    DW      (?)             ; #chars in header
THD#                    DW      (?)

; NOTES on THD#
; From:  Jim Bradley
; The last two bytes control the display, as follows:
; yxxE   top of thread
; yxxC   message in middle of thread
; yxxD   end of thread
; yxxF   this appears to be top of thread but
;        an antecedent message is not present
;
; y00z   indentation (apparently in spaces)
; y02z   (my setting is two spaces per level)
; y04z
;        The meaning of the y nibble is given elsewhere in the notes. (where?)
;       (here?) The y half-byte may contain flags.
;               I have found precisely one message in a very large group
;               which contains the binary value  0001 in that half byte,
;               but I don't have that scoped out yet.
; My Comments:
; 1. The indent value effects all NGs/folders
;    Coding it in the IDX file makes no sense.
;      Thd# doesn't change when the indent value is changed (but display does).
;      And new headers keep the same THD# structure.
;    yy has one format in NG/folders, and another in MAIL.
; 2. Is Jim reversing the order of nibbles (aka half-bites)?
;    Mine look different.
;       - I never observe the z values he shows.
;    Considering only threaded messages: (NG/Folder example)
;    "Thread order" == y ascending        Displays as:
; Thread 1
;    1 20 0       (ID=A)  (NUM=P) (REF=0) Subject
;    3 00 0       (ID=B)  (NUM=Q) (REF=A) (Nspaces) Author
;    5 10 0       (ID=C)  (NUM=R) (REF=B)           (Nspaces) Author
;
; Thread 2
;    1 29 2       (ID=A)  (NUM=0) (REF=X) Re: Subject
;    2 00 0       (ID=B)  (NUM=0) (REF=X) author
;    4 40 2       (ID=C)  (NUM=0) (REF=B) (Nspaces) Author
;    4 50 2       (ID=D)  (NUM=0) (REF=B) (Nspaces) Author
;
; Mail Thread
;    1 A5 2       (ID=A)  (NUM=0) (REF=0) Subject
;    2 40 2       (ID=B)  (NUM=0) (REF=0) (Nspaces) Author
;    3 CF 2       (ID=C)  (NUM=0) (REF=0) (Nspaces) Author
;    2 10 0       (ID=D)  (NUM=0) (REF=0) (Nspaces) Author
MSG_IDX         ENDS

FIELDS                                          ; begin fixed fields
FIXED_LEN               DW      (?)             ; bytes in Fixed fields
                                                ; offset to VAR_FIELDS
; What follows is of marginal use to me.
; my codes:
;       w indicates DW (short integer)
;       ORD = Override defaults
;       Option values shown replace the 1st byte, NULL is a "field terminator"?
; If ORD=01, then values are defaults (ignore mine I played with them)
; If this confuses you, welcome to the club. :-)
FIELDS_FIXED
;  OFS VAL     Menu/Options     Description

;  302 00 00   MARKREAD         When retrieving new headers (Options)
               00               Do not mark any existing messages read
               01               Mark all existing messages read
               02               Mark only messages without bodies read
;  304 00 00   MARKREAD         When retrieving marked message bodies (Options)
               00               Do not mark any existing messages read
               01               Mark all existing messages read
               02               Mark only messages without bodies read
;  306 01 00
;  308 00 00   WHA2PURG         Purge Unread Messages w/o bodies (Options)
               00               When message is no longer available
               01               When message is older than: ___ days
               02               Never
;  30A 1E 00 w WHA2PURG         Purge Unread Messages w/o bodies (Days shortint)
;  30C 01 00
;  30E 03 00   WHA2PURG         Purge Unread Messages w/bodies (Options)
               00               When message is older than: ___ days
               01               On every purge
               02               On every purge, delete body only
               03               Never
;  310 1E 00 w WHA2PURG         days shortint
;  312 00 00 00 00 00 00 00 00 00 00 00 00 00 00
;  320 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
;  330 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
;  340 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
;  350 00 00 00
;  353 00 00       RETRIEVE     Retrieve bodies for all new messages
;  355 00 00       RETRIEVE     Do not retrieve bodies longer than
;  357 F4 01 w     RETRIEVE     Lines limit shortint
;  359 00 00       RETRIEVE     Limit number of headers retrieved per session to
;  35B F4 01 w     RETRIEVE     Number limit shortint
;  35D 00 00       POST         Signature: signature name space
                                { Fixed length field follows }
;  3B2 01 00   ORD_MARKREAD     Override (01=Use) default settings
;  3B4 01 00   ORD_WHA2PURG     Override (01=Use) default settings
;  3B6 01 00                    ???
;  3B8 01 00                    ???
;  3BA 01 00   ORD_RETRIEVE     Override (01=Use) default settings
;  3BC 01 00   ORD_POST         Override (01=Use) default settings
;  3BE 03 00                    ???

;  3C0 32 00                    ???
;  3C2 01 00   ORD_DIR          Override (01=Use) default settings
;  3C4                          Directory Path Space (NULS delimit)

;  4C4 07                       ??? Same in all files.
;  4C5 00 65 6E 75 00

;  4CA 00 00                    ???
;  4CC 00 00   WHA2PURG         Purge Read Messages w/o bodies (Options)
               00               When message is no longer available
               01               When message is older than:
               02               Never
;  4CE 1E 00 w WHA2PURG         Purge Read Messages w/o bodies (Days shortint)
;  4D0 03 00   WHA2PURG         Purge Read message w/bodies (Options)
               00               When message is older than:
               01               On every purge
               02               On every purge, delete body only
               03               Never
;  4D2 1E 00 w WHA2PURG         Purge Read message w/bodies (Days, shortint)
;  4D4 00 00       POST         Copy follow-up messages to author via email
;  4D6 98 00       POST         FieldLen(CharsSum+15d)h LO/HI
;  4D8 00 00       POST         From:
;  4DA 00 00       POST         Cc:
;  4DC 00 00       POST         Bcc:
;  4DE 01 00
;  4E0 01 00
;  4E2 00 00       POST         Followup-To:
;  4E4 00 00       POST         Distribution:
;  4E6 00 00       POST         Keywords:
;  4E8 00 00       POST         Summary:
;  4EA 00 00       POST         Sender:
;  4EC 00 00       POST         Organization:
;  4EE 00 00       POST         Reply-To:
;  4F0 00 00       POST         Expires:
;  4F2 00 00       POST         Newsgroups:
;  4F4 00          POST         File sent Messages in Folder: (Options)
                   00           Delete
                   01           Leave in outbox
                   02           File in folder
;  4F5 00          POST         Prevent usenet messages from being archived
;  4F6 00                       ???
;  4F7 00          POST         Observe no archive requests from original message in followups
;  4F8 00 00       POST         File In folder_name long_int
;  4FC 00 00       FILTERS      Disable filtering for this group
;  4FE 01 00   ORD_FILTERS      Override (01=Use) default settings
                                "Initial Settings for New Filters"
;  500 00 00                    ???
;  502 01 00       FILTERS      Kill Action (Options)
;                  00           Skip
;                  01           Mark Read
;                  02           Ignore Thread
;  504 05 00       FILTERS      Watch Action (Options)
;                  03           Retrieve body immediately
;                  04           Mark for later retrieval
;                  05           Watch thread
;  506 01          FILTERS      Watch Action Keep
;  507 00          FILTERS      Scope
;                  00           Global
;                  01           Selected Group
;  508 90 01       FILTERS      Kill Action Priority: short_int
;  50A 58 02       FILTERS      Watch Action Priority: short_int
;  50C 00 00       FILTERS      Expire in ___ days
;  50E 1E 00       FILTERS      days short_int
;  510 01 00   ORD_LANGUAGE
;  512 EE CF 8B 31 LANGUAGE     long_int
;                               EE CF 8B 31 = English (American)
;  516 01 00                    ???
;  518 00 00       FILTERS      Watch Action Search For: (Options)
;                  00           Subject
;                  01           Author
;  51A 00 00                    ???
;  51C 00 00                    ???
;  51E 00 00                    ???

;  520 00 00                    ???

;  530 01 00   ORD_SEND         Override (01=Use) default settings
;  532 01 00       SEND Usenet  Format MIME/UUE
;  534 01 00       SEND Usenet  AttachFnInSubject
;  536 00 00       SEND Usenet  AttachPlacement Options
;  538 00 00       SEND Usenet  SendLargeMsgAsMultiple-Msgs
;  53A 01          SEND Usenet  SendTextAs0/n
;  53B 00          SEND Usenet  SendAttachAsDigest
;  53C 20 A1 07 00 SEND Usenet  Max bytes per section 4 bytes lo order 1st.
;  540 00 00       SEND Mail    Format MIME/UUE
;  542 00 00       SEND Mail    AttachFnInSubject
;  544 00 00       SEND Mail    AttachPlacement Options
;  546 00 00       SEND Mail    SendLargeMsgAsMultiple-Msgs
;  548 00          SEND Mail    SendTextAs0/n
;  549 00          SEND Mail    SendAttachAsDigest
;  54A 20 A1 07 00 SEND Mail    Max bytes per section (4 bytes lo order 1st)
;  54E 01 00   ORD_RECEIVE      Override (01=Use) default settings
;  550 00 00      _RECEIVE      Save attachments automatically
;  552 01          RECEIVE      After saving an attachment, remove it from the message
;  553 00          RECEIVE      Ignore fragments
;  554 00          RECEIVE      If a filename already existsExists (Options)
;                  00           Save and leave in message
;                  01           Do not save (leave in message)
;                  02           Overwrite existing file
;  555 00          RECEIVE      If a decoding Error occurs (Options)
;                  00           Save and leave in message
;                  01           Do not save (leave in message)
;                  02           Overwrite existing file
;  556 00          RECEIVE      Burst digests into separate messages
;  557 01          RECEIVE      Join multipart messages when saving or launching attachments
;  558 01          RECEIVE      Detect UUencoded files automatically
;  559 01          RECEIVE      Double-clicking launches attachments
;  55A 00          RECEIVE      When launching an attachment, first save it as a file
;  55B 01          RECEIVE      Join multipart messages when retrieving headers
;  55C 01 00   ORD_XPOSTS       Override (01=Use) defaults
;                               Enable crosspost checking changes AGENT.INI
;                               [Xpost], Enable=0|1
;  55E 01 00       XPOSTS       Retrieve (Options)
;                               "If a message header has already been
;                               retrieved in another group,
;                               perform the following action in this group:"
;                  00           Retrieve the header normally
;                  01           Mark the header read
;                  02           Skip the header (do not retrieve it)
;  560 00 00       XPOSTS       Look for crossposted messages only when retrieving NEW headers
;                  XPOSTS       Detect crossposted messages by:
;                               changes AGENT.INI
;                                  [Xpost]
;                                  Method=0 (Subject, author, date, and lines)
;                                  Method=1 (Message ID)
;                                  Does not change any DAT fields }

;  562 00 00                    FieldsEndMarker (or unknown?)
;  564 00                       FieldDelim (or UnknownField?)
;  End of fixed fields

VAR_FIELDS                              ; 14d ASCIIZ strings
                                        ; Overides to Default values
                                        ; contained in GRPPROPS.DAT
From                    DB
Cc                      DB
Bcc                     DB
Unknown1                DB
Unknown2                DB
Followup-To             DB
Distribution            DB
Keywords                DB
Summary                 DB
Sender                  DB
Organization            DB
Reply-To                DB
Expires                 DB
Newsgroups              DB

VIEWMAPS                                ; Bitmaps govern messages displayed
                                        ; based on the Group view selected
                                        ; Each bit represents an IDX record.
                                        ; Additional options can be created
                                        ; using Filters (un-explored)
READbm_LEN              DW      (?)     ; Length of bitmap (bytes)
                                        ; Assigned in blocks of 4 bytes.
readbm                  DB      (?)     ; UnRead messages
MARKbm_LEN              DW      (?)
markbm                  DB      (?)     ; Headers marked for retrieval
WATCHbm_LEN             DW      (?)
watchbm                 DB      (?)     ; Messages watched
IGNOREbm_LEN            DW      (?)
ignorebm                DB      (?)     ; Messages Ignored
KEEPbm_LEN              DW      (?)
keepbm                  DB      (?)     ; Messages locked
BODYbm_LEN              DW      (?)
bodybm                  DB      (?)     ; Messages with bodies
EOF                     DW      (?)
;*** End    IDX file structure  ***
