/*
	Filename:	8SVX.c
	Date:			20.96.11.25
	Compiler:	Borland C++ 5.0
	Target:		DOS Large

	Electronic Arts IFF 8SVX (8-Bit Sampled Voice) File Routines
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define SVX8_C
#ifndef SVX8_H
#include "8svx.h"
#endif	/* SVX8_H */

struct SVX8_8svx *SVX8_Read(string filename);
int SVX8_Write(string filename,struct SVX8_8svx *svx);

///////////////////////////////////////////////////////////////

struct SVX8_8svx *SVX8_Read(string filename)
{
	/*
		Inputs:		Filename String
		Output:		Pointer to Allocated and Filled SVX8_8svx structure
		Synopsis:	Read 8SVX File Information and Data
	*/
   int Status = 0;
   uchar FoundVHDR = 0;
   struct IFF_Chunk *Chk;
   struct SVX8_8svx *svx;

   IFF_Error = IFFERROR_NONE;
   if((svx = (struct SVX8_8svx *)IFF_Malloc(sizeof(struct SVX8_8svx))))
	{
   	setmem(svx,sizeof(struct SVX8_8svx),0);
	   if(IFF_ReadFile(filename,ID_8SVX,&svx->CList))
	   {
         /* Parse Chunks */
         for(Chk = svx->CList.First; Chk != NULL; Chk = Chk->Next)
         {
	         if(Chk->ID == ID_VHDR)
			   {
               svx->Vhdr = Chk;
	            FoundVHDR = 1;
	         }
	         else if(Chk->ID == ID_NAME)
					svx->Name = Chk;
	         else if(Chk->ID == ID_COPYRIGHT)
            	svx->Copyright = Chk;
	         else if(Chk->ID == ID_AUTH)
            	svx->Author = Chk;
	         else if(Chk->ID == ID_ANNO)
            	svx->Annotations = Chk;
	         else if(Chk->ID == ID_CHAN)
            	svx->Chan = Chk;
	         else if(Chk->ID == ID_BODY)
	         {
	         	/* Must precede Body of Data */
	            if(FoundVHDR)
	            {
	            	struct SVX8_Vhdr *vhdr;

	               vhdr = (struct SVX8_Vhdr *)(svx->Vhdr->Data);
	               svx->Body = Chk;

		            /* Compression is Fibonacci Delta */
		            if(vhdr->Compression == SVX8_CmpFibDelta)
		            {
		            	char far *Body,*src,*dst;
		               char d,x;
		               long i,n,lim;
		               char CodeToDelta[16] = { -34,-21,-13,-8,-5,-3,-2,-1,0,1,2,3,5,8,13,21 };

		               Body = svx->Body->Data;
		               if(!(svx->Body->Data = (char far *)IFF_Farmalloc(svx->Body->Size << 1)))
		               	break;

		               /* Fibonacci Delta Decompression */
		               src = Body+2;
		               dst = svx->Body->Data;
		               n = svx->Body->Size-2;
		               x = Body[1];
		               lim = n << 1;
		               for(i = 0; i < lim; ++i)
		               {
		               	d = src[i >> 1];
		                  if(i & 1) d &= 0xF;
		                  else d >>= 4;
		                  x += CodeToDelta[d];
		                  dst[i] = x;
		               }
		               farfree(Body);
		               svx->Body->Size <<= 1;
		               Status = 1;
		            }
		            /* No Compression, exit OKAY */
				      else if(vhdr->Compression == SVX8_CmpNone)
		            	Status = 1;
				      /* Compression is Unknown */
		            else
		            	IFF_Error = IFFERROR_COMPRESSION;
               }
               else
               {
	            	IFF_Error = IFFERROR_NOVHDR;
	               break;
               }
	         }
         }
      }
   }
   /* In the event of error, free all memory allocated within */
   if(Status == 0)
   {
   	struct IFF_Chunk *NChk;

   	/* Delete All Chunks in ChunkList */
		for(Chk = svx->CList.First; Chk != NULL; Chk = NChk)
      {
      	NChk = Chk->Next;
      	DeleteChunk(&svx->CList,Chk);
      }
      free(svx);
   	return(NULL);
   }
   return(svx);
}

///////////////////////////////////////////////////////////////

int SVX8_Write(string filename,struct SVX8_8svx *svx)
{
	/*
		Inputs:		Filename String
      				Pointer to SVX8_8svx structure
		Output:		1 for Success; 0 for Failure
		Synopsis:	Write 8SVX File Information and Data
	*/

	IFF_Error = IFFERROR_NONE;

   /* Perform Body Compression Here !! */

   return(IFF_WriteFile(filename,ID_8SVX,&svx->CList));
}

